/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.google.common.collect.Lists;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.classic.recipe.custom.IClassicScrapBoxManager;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.item.recipe.AdvRecipeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.recipe.IC2CRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;

final class IC2CIntegration
extends AbstractIntegrationThread {
    IC2CIntegration() {
        super("Industrial Craft 2 Classic");
    }

    public String call() {
        try {
            this.fixMachineOutput(ClassicRecipes.macerator);
            this.fixMachineOutput(ClassicRecipes.compressor);
            this.fixMachineOutput(ClassicRecipes.extractor);
            this.fixMachineOutput(ClassicRecipes.sawMill);
            this.fixMachineOutput((IMachineRecipeList)ClassicRecipes.recycler);
            this.fixScrapBoxDrops();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.threadName + "Expect the world to be nuked by the Industrial Revolution.";
    }

    private void fixMachineOutput(@Nonnull IMachineRecipeList iMachineRecipeList) {
        List recipeEntryList = iMachineRecipeList.getRecipeMap();
        if (recipeEntryList == null || recipeEntryList.isEmpty()) {
            return;
        }
        HashMap<IMachineRecipeList.RecipeEntry, List> recipeEntryListMap = new HashMap<IMachineRecipeList.RecipeEntry, List>();
        for (IMachineRecipeList.RecipeEntry recipeEntry2 : recipeEntryList) {
            List<ItemStack> newOutputList;
            List outputList;
            MachineOutput machineOutput = recipeEntry2.getOutput();
            if (!recipeEntry2.getOutput().canOverride() || (outputList = machineOutput.getAllOutputs()) == (newOutputList = this.resourceHandler.getMainItemStacksChecked(outputList))) continue;
            recipeEntryListMap.put(recipeEntry2, newOutputList);
        }
        recipeEntryListMap.forEach((recipeEntry, newOutputsList) -> {
            iMachineRecipeList.removeRecipe(recipeEntry);
            iMachineRecipeList.addRecipe(recipeEntry.getInput(), recipeEntry.getOutput().overrideOutput(newOutputsList), recipeEntry.getRecipeID());
        });
    }

    private void fixScrapBoxDrops() {
        IClassicScrapBoxManager classicScrapBoxManager = ClassicRecipes.scrapboxDrops;
        List dropList = classicScrapBoxManager.getEntries();
        HashMap<IClassicScrapBoxManager.IDrop, ItemStack> newDrops = new HashMap<IClassicScrapBoxManager.IDrop, ItemStack>();
        for (IClassicScrapBoxManager.IDrop drop2 : dropList) {
            ItemStack newItemStackDrop2 = this.resourceHandler.getMainItemStack(drop2.getDrop());
            if (newItemStackDrop2 == drop2.getDrop()) continue;
            newDrops.put(drop2, newItemStackDrop2);
        }
        newDrops.forEach((drop, newItemStackDrop) -> {
            classicScrapBoxManager.removeDrop(drop);
            classicScrapBoxManager.addDrop(newItemStackDrop, drop.getRawChance());
        });
    }

    static void fixAdvancedRecipes(ResourceHandler resourceHandler) {
        ICraftingRecipeList advCrafting = ClassicRecipes.advCrafting;
        List advRecipeList = advCrafting.getRecipes();
        HashMap<AdvRecipeBase, ItemStack> advRecipeItemStackMap = new HashMap<AdvRecipeBase, ItemStack>();
        for (IAdvRecipe advRecipe2 : advRecipeList) {
            ItemStack newOutput2;
            ItemStack output;
            if (!(advRecipe2 instanceof AdvRecipeBase) || !advRecipe2.isInvisible() || (output = ((AdvRecipeBase)advRecipe2).func_77571_b()) == (newOutput2 = resourceHandler.getMainItemStack(output))) continue;
            advRecipeItemStackMap.put((AdvRecipeBase)advRecipe2, newOutput2);
        }
        advRecipeItemStackMap.forEach((advRecipe, newOutput) -> {
            switch (advRecipe.getRecipeType()) {
                case Shaped: {
                    ArrayList newShapedInputs = Lists.newArrayList((Object[])RecipeHelper.rawShapeToShape((Object[])IC2CRecipeResearcher.getNewShapedRecipeInputs((AdvRecipeBase)advRecipe, (ResourceHandler)resourceHandler)).actualShape);
                    newShapedInputs.add(true);
                    advCrafting.overrideRecipe(advRecipe.getRecipeID(), newOutput, newShapedInputs.toArray());
                    break;
                }
                case Shapeless: {
                    List<Object> newShapelessInputs = IC2CRecipeResearcher.getNewShapelessRecipeInputs(advRecipe, resourceHandler);
                    newShapelessInputs.add(true);
                    advCrafting.overrideShapelessRecipe(advRecipe.getRecipeID(), newOutput, newShapelessInputs.toArray());
                }
            }
        });
    }
}

