/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.block;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.block.BlockBasic;
import shadows.placebo.block.IEnumBlock;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.itemblock.ItemBlockEnum;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.PlaceboUtil;

public abstract class BlockEnum<E extends Enum<E>>
extends BlockBasic
implements IEnumBlock<E> {
    protected final List<E> types = new ArrayList();
    protected final Predicate<E> valueFilter;
    protected final PropertyEnum<E> property;
    protected final BlockStateContainer realStateContainer;

    public BlockEnum(String name, Material material, SoundType sound, float hardness, float resistance, Class<E> enumClass, String propName, Predicate<E> valueFilter, RegistryInformation info) {
        super(name, material, hardness, resistance, info);
        this.func_149672_a(sound);
        this.valueFilter = valueFilter;
        this.property = PropertyEnum.func_177708_a((String)propName, enumClass, valueFilter);
        this.types.addAll(this.property.func_177700_c());
        this.realStateContainer = this.createStateContainer();
        this.func_180632_j(this.func_176194_O().func_177621_b());
        for (Enum e : this.types) {
            ((IPropertyEnum)((Object)e)).set((IForgeRegistryEntry<?>)this);
        }
    }

    public BlockEnum(String name, Material material, SoundType sound, float hardness, float resistance, Class<E> enumClass, String propName, RegistryInformation info) {
        this(name, material, sound, hardness, resistance, enumClass, propName, Predicates.alwaysTrue(), info);
    }

    public BlockEnum(String name, Material material, SoundType sound, float hardness, float resistance, Class<E> enumClass, RegistryInformation info) {
        this(name, material, sound, hardness, resistance, enumClass, "type", info);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockEnum(this);
    }

    @Override
    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.types.size(); ++i) {
            PlaceboUtil.sMRL("blocks", this, i, "type=" + ((IPropertyEnum)((Object)((Enum)this.types.get(i)))).func_176610_l());
        }
        Placebo.PROXY.useRenamedMapper(this, "blocks");
    }

    public final BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).build();
    }

    public final BlockStateContainer func_176194_O() {
        return this.realStateContainer;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.property, (Comparable)this.types.get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.property))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.types.size(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.property});
    }

    @Override
    public List<E> getTypes() {
        return this.types;
    }

    @Override
    public PropertyEnum<E> getProperty() {
        return this.property;
    }

    @Override
    public BlockStateContainer getRealStateContainer() {
        return this.realStateContainer;
    }

    @Override
    public IBlockState getStateFor(E e) {
        return this.func_176223_P().func_177226_a(this.property, e);
    }
}

