/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.items.shulker;

import cpw.mods.ironchest.common.blocks.shulker.BlockIronShulkerBox;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.core.IronChestCreativeTabs;
import cpw.mods.ironchest.common.items.ShulkerBoxChangerType;
import cpw.mods.ironchest.common.lib.BlockLists;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import cpw.mods.ironchest.common.util.ItemTooltip;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemShulkerBoxChanger
extends ItemTooltip {
    public final ShulkerBoxChangerType type;

    public ItemShulkerBoxChanger(ShulkerBoxChangerType type) {
        this.type = type;
        this.func_77625_d(1);
        this.func_77655_b("ironchest.shulker_box." + type.name().toLowerCase(Locale.US));
        this.func_77637_a(IronChestCreativeTabs.tabIronChests);
    }

    public EnumDyeColor getColorFromTileEntity(TileEntity te, World worldIn) {
        block2: {
            block3: {
                if (te == null) break block2;
                if (!(te instanceof TileEntityIronShulkerBox)) break block3;
                TileEntityIronShulkerBox ironShulkerBox = (TileEntityIronShulkerBox)te;
                Block ironShulkerBoxBlock = worldIn.func_180495_p(ironShulkerBox.func_174877_v()).func_177230_c();
                for (int i = 0; i < BlockLists.SHULKER_BLOCKS.size(); ++i) {
                    if (BlockLists.SHULKER_BLOCKS.get(i) != ironShulkerBoxBlock) continue;
                    return BlockLists.VANILLA_SHULKER_COLORS.get(i);
                }
                break block2;
            }
            if (!(te instanceof TileEntityShulkerBox)) break block2;
            TileEntityShulkerBox shulkerBox = (TileEntityShulkerBox)te;
            Block shulkerBoxBlock = worldIn.func_180495_p(shulkerBox.func_174877_v()).func_177230_c();
            for (int i = 0; i < BlockLists.VANILLA_SHULKER_BLOCKS.size(); ++i) {
                if (BlockLists.VANILLA_SHULKER_BLOCKS.get(i) != shulkerBoxBlock) continue;
                return BlockLists.VANILLA_SHULKER_COLORS.get(i);
            }
        }
        return EnumDyeColor.PURPLE;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (this.type.canUpgrade(IronShulkerBoxType.VANILLA)) {
            if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockShulkerBox)) {
                return EnumActionResult.PASS;
            }
        } else if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockIronShulkerBox) {
            if (worldIn.func_180495_p(pos) != ((BlockIronShulkerBox)worldIn.func_180495_p(pos).func_177230_c()).func_176203_a(IronShulkerBoxType.valueOf(this.type.source.func_176610_l().toUpperCase()).ordinal())) {
                return EnumActionResult.PASS;
            }
        } else {
            return EnumActionResult.PASS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        TileEntityIronShulkerBox newShulkerBox = new TileEntityIronShulkerBox();
        NonNullList shulkerBoxContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        EnumFacing shulkerBoxFacing = EnumFacing.UP;
        EnumDyeColor shulkerBoxColor = EnumDyeColor.PURPLE;
        if (te != null) {
            if (te instanceof TileEntityIronShulkerBox) {
                shulkerBoxContents = ((TileEntityIronShulkerBox)te).func_190576_q();
                shulkerBoxFacing = ((TileEntityIronShulkerBox)te).getFacing();
                shulkerBoxColor = this.getColorFromTileEntity(te, worldIn);
                ((TileEntityIronShulkerBox)te).setHasBeenUpgraded();
                newShulkerBox = this.type.target.makeEntity(shulkerBoxColor);
                if (newShulkerBox == null) {
                    return EnumActionResult.PASS;
                }
            } else if (te instanceof TileEntityShulkerBox) {
                IBlockState shulkerBoxState = worldIn.func_180495_p(pos);
                shulkerBoxFacing = (EnumFacing)shulkerBoxState.func_177229_b((IProperty)BlockShulkerBox.field_190957_a);
                TileEntityShulkerBox shulkerBox = (TileEntityShulkerBox)te;
                if (!this.type.canUpgrade(IronShulkerBoxType.VANILLA)) {
                    return EnumActionResult.PASS;
                }
                shulkerBoxContents = NonNullList.func_191197_a((int)shulkerBox.func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < shulkerBoxContents.size(); ++i) {
                    shulkerBoxContents.set(i, (Object)shulkerBox.func_70301_a(i));
                }
                shulkerBoxColor = this.getColorFromTileEntity(te, worldIn);
                shulkerBox.func_174888_l();
                shulkerBox.func_190579_a(true);
                newShulkerBox = this.type.target.makeEntity(shulkerBoxColor);
            }
        }
        te.func_145836_u();
        worldIn.func_175698_g(pos);
        IBlockState iblockstate = null;
        if (BlockLists.SHULKER_BLOCKS.get(shulkerBoxColor.func_176765_a()) == null) {
            return EnumActionResult.PASS;
        }
        Block block = BlockLists.SHULKER_BLOCKS.get(shulkerBoxColor.func_176765_a());
        iblockstate = block.func_176223_P().func_177226_a(BlockIronShulkerBox.VARIANT_PROP, (Comparable)((Object)this.type.target));
        worldIn.func_175690_a(pos, (TileEntity)newShulkerBox);
        worldIn.func_180501_a(pos, iblockstate, 3);
        worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
        TileEntity te2 = worldIn.func_175625_s(pos);
        if (te2 instanceof TileEntityIronShulkerBox) {
            ((TileEntityIronShulkerBox)te2).setContents((NonNullList<ItemStack>)shulkerBoxContents);
            ((TileEntityIronShulkerBox)te2).setFacing(shulkerBoxFacing);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }
}

