/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tweaker;

import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTConverter
implements IDataConverter<NBTBase> {
    public static final NBTConverter INSTANCE = new NBTConverter();

    public static NBTBase from(IData data) {
        return (NBTBase)data.convert((IDataConverter)INSTANCE);
    }

    public NBTBase fromBool(boolean value) {
        return new NBTTagInt(value ? 1 : 0);
    }

    public NBTBase fromByte(byte value) {
        return new NBTTagByte(value);
    }

    public NBTBase fromShort(short value) {
        return new NBTTagShort(value);
    }

    public NBTBase fromInt(int value) {
        return new NBTTagInt(value);
    }

    public NBTBase fromLong(long value) {
        return new NBTTagLong(value);
    }

    public NBTBase fromFloat(float value) {
        return new NBTTagFloat(value);
    }

    public NBTBase fromDouble(double value) {
        return new NBTTagDouble(value);
    }

    public NBTBase fromString(String value) {
        return new NBTTagString(value);
    }

    public NBTBase fromList(List<IData> values) {
        NBTTagList result = new NBTTagList();
        for (IData value : values) {
            result.func_74742_a(NBTConverter.from(value));
        }
        return result;
    }

    public NBTBase fromMap(Map<String, IData> values) {
        NBTTagCompound result = new NBTTagCompound();
        for (Map.Entry<String, IData> entry2 : values.entrySet()) {
            result.func_74782_a(entry2.getKey(), NBTConverter.from(entry2.getValue()));
        }
        return result;
    }

    public NBTBase fromByteArray(byte[] value) {
        return new NBTTagByteArray(value);
    }

    public NBTBase fromIntArray(int[] value) {
        return new NBTTagIntArray(value);
    }
}

