/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.recipes;

import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.recipes.SingleInputStackMatchRecipeCached;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class SingleInputStackToStackRecipeCached
extends SingleInputStackMatchRecipeCached {
    public final MachineSlotItem slotOutput;
    HashMap<ItemRef, ItemStack> cache = new HashMap();

    protected SingleInputStackToStackRecipeCached(MachineSlotItem inputSlot, MachineSlotItem slotOutput) {
        super(inputSlot);
        this.slotOutput = slotOutput;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return StackHelper.isNonNull(this.getCachedResult(stack));
    }

    public ItemStack getCachedResult(ItemStack stack) {
        if (StackHelper.isNull(stack) || stack.func_77973_b() == StackHelper.nullItem()) {
            return StackHelper.empty();
        }
        ItemRef wrap = ItemRef.wrapCrafting(stack);
        return this.cache.computeIfAbsent(wrap, key -> this.getResult(key.createItemStack(1)));
    }

    public abstract ItemStack getResult(@Nonnull ItemStack var1);

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.inputSlot);
        ItemStack itemstack = this.getCachedResult(stack);
        if (StackHelper.isNull(itemstack)) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)this.slotOutput, (Object)itemstack.func_77946_l());
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return ImmutableMap.of();
    }
}

