/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.IItemFluidHandlerCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileItemWrapper
extends XUTile
implements IDynamicHandler {
    public static final IEnergyStorage EMPTY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    };
    public SingleStackHandler stackSlot = this.registerNBT("stack", new SingleStackHandler());
    public IEnergyStorage energyHandler = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.getStorage().receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.getStorage().extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.getStorage().getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.getStorage().getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.getStorage().canExtract();
        }

        public boolean canReceive() {
            return this.getStorage().canReceive();
        }

        @Nonnull
        public IEnergyStorage getStorage() {
            ItemStack stack = TileItemWrapper.this.stackSlot.getStack();
            if (StackHelper.isEmpty(stack)) {
                return EMPTY_STORAGE;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage == null) {
                return EMPTY_STORAGE;
            }
            return energyStorage;
        }
    };
    public IFluidHandler fluidHandler = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            return this.getFluidHandler().getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (doFill) {
                IItemFluidHandlerCompat fluidHandler = this.getFluidHandler();
                int fill = fluidHandler.fill(resource, true);
                TileItemWrapper.this.stackSlot.setStack(fluidHandler.getModifiedStack());
                TileItemWrapper.this.func_70296_d();
                return fill;
            }
            return this.getFluidHandler().fill(resource, false);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (doDrain) {
                IItemFluidHandlerCompat fluidHandler = this.getFluidHandler();
                FluidStack drain = fluidHandler.drain(resource, true);
                TileItemWrapper.this.stackSlot.setStack(fluidHandler.getModifiedStack());
                TileItemWrapper.this.func_70296_d();
                return drain;
            }
            return this.getFluidHandler().drain(resource, false);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (doDrain) {
                IItemFluidHandlerCompat fluidHandler = this.getFluidHandler();
                FluidStack drain = fluidHandler.drain(maxDrain, true);
                TileItemWrapper.this.stackSlot.setStack(fluidHandler.getModifiedStack());
                TileItemWrapper.this.func_70296_d();
                return drain;
            }
            return this.getFluidHandler().drain(maxDrain, false);
        }

        public IItemFluidHandlerCompat getFluidHandler() {
            ItemStack stack = TileItemWrapper.this.stackSlot.getStack();
            if (StackHelper.isEmpty(stack)) {
                return this.wrap(stack, (IFluidHandler)EmptyFluidHandler.INSTANCE);
            }
            IItemFluidHandlerCompat itemCap = IItemFluidHandlerCompat.getFluidHandler(stack);
            if (itemCap != null) {
                return itemCap;
            }
            IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (fluidHandler != null) {
                return this.wrap(stack, fluidHandler);
            }
            return this.wrap(stack, (IFluidHandler)EmptyFluidHandler.INSTANCE);
        }

        private IItemFluidHandlerCompat wrap(final ItemStack stack, final IFluidHandler instance) {
            return new IItemFluidHandlerCompat(){

                @Override
                @Nonnull
                public ItemStack getModifiedStack() {
                    return stack;
                }

                public IFluidTankProperties[] getTankProperties() {
                    return instance.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return instance.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return instance.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return instance.drain(maxDrain, doDrain);
                }
            };
        }
    };
    public IItemHandlerModifiableCompat itemHandler = new IItemHandlerModifiableCompat(){

        @Override
        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
            if (slot == 0) {
                TileItemWrapper.this.stackSlot.setStackInSlot(0, stack);
            } else {
                IItemHandler handler = this.getHandler();
                if (handler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(slot - 1, stack);
                }
            }
        }

        @Override
        public int getSlots() {
            return this.getHandler().getSlots() + 1;
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return TileItemWrapper.this.stackSlot.getStack();
            }
            return this.getHandler().getStackInSlot(slot - 1);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            TileItemWrapper.this.func_70296_d();
            if (slot == 0) {
                return TileItemWrapper.this.stackSlot.insertItem(0, stack, simulate);
            }
            return this.getHandler().insertItem(slot - 1, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            TileItemWrapper.this.func_70296_d();
            if (slot == 0) {
                return TileItemWrapper.this.stackSlot.extractItem(0, amount, simulate);
            }
            return this.getHandler().extractItem(slot - 1, amount, simulate);
        }

        @Nonnull
        public IItemHandler getHandler() {
            ItemStack stack = TileItemWrapper.this.stackSlot.getStack();
            if (StackHelper.isEmpty(stack)) {
                return EmptyHandler.INSTANCE;
            }
            IItemHandler capability = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return EmptyHandler.INSTANCE;
            }
            return capability;
        }
    };

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluidHandler;
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator((IItemHandler)this.stackSlot);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.energyHandler;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.itemHandler;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerWrapper(this, player);
    }

    public static abstract class WidgetProgresSHorizScrollColored
    extends WidgetBase
    implements IWidgetServerNetwork {
        final String text;
        final int color;
        int max = 0;
        int val = 0;

        public WidgetProgresSHorizScrollColored(String text, int x, int y, int color) {
            super(x, y, 52, 11);
            this.text = text;
            this.color = color;
        }

        @Override
        public List<String> getToolTip() {
            if (this.max == 0) {
                return ImmutableList.of((Object)this.text);
            }
            return ImmutableList.of((Object)(this.text + ": " + StringHelper.format(this.val) + " / " + StringHelper.format(this.max)));
        }

        public abstract int[] getData();

        @Override
        public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 150, 52, 11);
            if (this.max > 0) {
                GlStateManager.func_179131_c((float)ColorHelper.getRF(this.color), (float)ColorHelper.getGF(this.color), (float)ColorHelper.getBF(this.color), (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, 0, 161, 50, 9);
                int displayValue = Math.round((float)this.val * 50.0f / (float)this.max);
                gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, 0, 170, displayValue, 9);
            } else {
                GlStateManager.func_179131_c((float)(ColorHelper.getRF(this.color) / 2.0f), (float)(ColorHelper.getGF(this.color) / 2.0f), (float)(ColorHelper.getBF(this.color) / 2.0f), (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, 0, 161, 50, 9);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void addToDescription(XUPacketBuffer packet) {
            int[] data = this.getData();
            if (data == null) {
                packet.writeVarInt(0);
                packet.writeVarInt(0);
            } else {
                packet.writeVarInt(data[0]);
                packet.writeVarInt(data[1]);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleDescriptionPacket(XUPacketBuffer packet) {
            this.val = packet.readVarInt();
            this.max = packet.readVarInt();
        }
    }

    public static class ContainerWrapper
    extends DynamicContainerTile {
        public ContainerWrapper(final TileItemWrapper tile, EntityPlayer player) {
            super(tile);
            int y = 18;
            int y_dist = 12;
            this.addWidget(new WidgetSlotItemHandler(tile.stackSlot, 0, 76, 18));
            int x = 98;
            this.addTitle(tile);
            this.addWidget(new WidgetProgresSHorizScrollColored(Lang.translate("Contained Inventory"), 98, 18, 16766976){

                @Override
                public int[] getData() {
                    ItemStack stack = tile.stackSlot.getStack();
                    if (StackHelper.isEmpty(stack)) {
                        return null;
                    }
                    IItemHandler capability = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    if (capability == null) {
                        return null;
                    }
                    IItemHandlerCompat itemHandler = CompatHelper.wrapItemHandlerCompat(capability);
                    if (itemHandler == null) {
                        return null;
                    }
                    int num = 0;
                    int max = 0;
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                        if (StackHelper.isEmpty(stackInSlot)) {
                            max += itemHandler.getSlotLimit(i);
                            continue;
                        }
                        max += itemHandler.getSlotLimit(i);
                        num += StackHelper.getStacksize(stackInSlot) * itemHandler.getSlotLimit(i) / stackInSlot.func_77976_d();
                    }
                    return new int[]{num, max};
                }
            });
            this.addWidget(new WidgetProgresSHorizScrollColored(Lang.translate("Contained Fluids"), 98, 30, 4718847){

                @Override
                public int[] getData() {
                    ItemStack stack = tile.stackSlot.getStack();
                    if (StackHelper.isNull(stack)) {
                        return null;
                    }
                    IItemFluidHandlerCompat fluidHandler = IItemFluidHandlerCompat.getFluidHandler(stack);
                    if (fluidHandler == null) {
                        return null;
                    }
                    int num = 0;
                    int max = 0;
                    for (IFluidTankProperties iFluidTankProperties : fluidHandler.getTankProperties()) {
                        FluidStack contents = iFluidTankProperties.getContents();
                        if (contents != null) {
                            num += contents.amount;
                        }
                        max += iFluidTankProperties.getCapacity();
                    }
                    return new int[]{num, max};
                }
            });
            this.addWidget(new WidgetProgresSHorizScrollColored(Lang.translate("Contained Energy"), 98, 42, 16725793){

                @Override
                public int[] getData() {
                    ItemStack stack = tile.stackSlot.getStack();
                    if (StackHelper.isEmpty(stack)) {
                        return null;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage == null) {
                        return null;
                    }
                    return new int[]{energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()};
                }
            });
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

