/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessEmpty;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessSingle;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.oredict.OreDictionary;

public class PinkRecipe
extends EnergyBaseRecipe {
    static Set<ItemRef> pinkThings;

    @Mod.EventHandler
    public static void oreRegister(OreDictionary.OreRegisterEvent event) {
        pinkThings = null;
    }

    @Override
    public int getEnergyOutput(@Nonnull ItemStack stack) {
        ItemRef itemRef = ItemRef.wrapNoNBT(stack);
        if (pinkThings == null) {
            pinkThings = new HashSet<ItemRef>();
            for (Block block : Block.field_149771_c) {
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    boolean flag = false;
                    if (!flag) {
                        for (Map.Entry entry2 : state.func_177228_b().entrySet()) {
                            if (((IProperty)entry2.getKey()).func_177699_b() == EnumDyeColor.class && entry2.getValue() == EnumDyeColor.PINK) {
                                flag = true;
                                break;
                            }
                            if (!((IProperty)entry2.getKey()).func_177701_a().contains("color") || !((IProperty)entry2.getKey()).func_177702_a((Comparable)entry2.getValue()).contains("pink")) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (!flag) continue;
                    try {
                        for (int i = 0; i < 10; ++i) {
                            List drops = block.getDrops((IBlockAccess)BlockAccessEmpty.INSTANCE, BlockAccessSingle.CENTER, state, 300);
                            for (ItemStack drop : drops) {
                                if (!StackHelper.isNonNull(drop)) continue;
                                pinkThings.add(ItemRef.wrapCrafting(drop));
                            }
                        }
                    }
                    catch (RuntimeException err) {
                        err.printStackTrace();
                    }
                }
            }
            for (String s : OreDictionary.getOreNames()) {
                if (!s.toLowerCase(Locale.ROOT).contains("pink")) continue;
                for (ItemStack itemStack : OreDictionary.getOres((String)s)) {
                    pinkThings.add(ItemRef.wrapCrafting(itemStack));
                }
            }
        }
        if (pinkThings.contains(itemRef) || itemRef.hasMeta() && pinkThings.contains(itemRef.toNoMetaVersion())) {
            return 400;
        }
        return 0;
    }

    @Override
    protected float getEnergyRate(@Nonnull ItemStack stack) {
        return 40.0f;
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getInputValues() {
        return EnergyBaseRecipe.getCreativeStacks(t -> this.getEnergyOutput((ItemStack)t) > 0, null);
    }

    static {
        MinecraftForge.EVENT_BUS.register(PinkRecipe.class);
    }
}

