/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.fluids.IFluidFilter;
import com.rwtema.extrautils2.api.items.IItemFilter;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.ITransferPriority;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.transfernodes.IBuffer;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SingleStackHandlerFilter
extends SingleStackHandler {
    @Override
    protected abstract int getStackLimit(@Nonnull ItemStack var1);

    public WidgetSlotItemHandler newSlot(int x, int y) {
        return new WidgetSlotFilter(this, x, y);
    }

    public abstract Item getExpectedItem();

    public boolean hasFilter() {
        return StackHelper.isNonNull(this.getStack());
    }

    public static class WidgetSlotFilter
    extends WidgetSlotItemHandler
    implements ITransferPriority {
        protected SingleStackHandlerFilter filter;

        public WidgetSlotFilter(SingleStackHandlerFilter filter, int x, int y) {
            super(filter, 0, x, y);
            this.filter = filter;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<String> getToolTip() {
            if (!this.func_75216_d()) {
                return ImmutableList.of((Object)Lang.getItemName(this.filter.getExpectedItem()));
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            super.renderBackground(manager, gui, guiLeft, guiTop);
            if (!this.func_75216_d()) {
                ItemStack stack = ItemIngredients.Type.FILTER_SKELETON.newStack();
                gui.renderStack(stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
            }
        }

        @Override
        public int getTransferPriority() {
            return 1;
        }
    }

    public static class ItemFilter
    extends SingleStackHandlerFilter {
        public boolean matches(ItemStack stack) {
            ItemStack filterStack = this.getStack();
            if (StackHelper.isNull(filterStack)) {
                return true;
            }
            Item item = filterStack.func_77973_b();
            return item instanceof IItemFilter && ((IItemFilter)item).matches(filterStack, stack);
        }

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            return this.isItemFilter(stack) ? stack.func_77976_d() : 0;
        }

        public boolean isItemFilter(ItemStack stack) {
            Item item;
            return StackHelper.isNonNull(stack) && (item = stack.func_77973_b()) instanceof IItemFilter && ((IItemFilter)item).isItemFilter(stack);
        }

        @Override
        public Item getExpectedItem() {
            return (Item)XU2Entries.filterItems.value;
        }
    }

    public static class EitherFilter
    extends SingleStackHandlerFilter {
        public boolean matches(ItemStack stack) {
            ItemStack filterStack = this.getStack();
            if (StackHelper.isNull(filterStack)) {
                return true;
            }
            Item item = filterStack.func_77973_b();
            return item instanceof IItemFilter && ((IItemFilter)item).matches(filterStack, stack);
        }

        public boolean matches(FluidStack stack) {
            ItemStack filterStack = this.getStack();
            if (StackHelper.isNull(filterStack)) {
                return true;
            }
            Item item = filterStack.func_77973_b();
            return item instanceof IFluidFilter && ((IFluidFilter)item).matches(filterStack, stack);
        }

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item instanceof IItemFilter && ((IItemFilter)item).isItemFilter(stack) || item instanceof IFluidFilter && ((IFluidFilter)item).isFluidFilter(stack)) {
                return stack.func_77976_d();
            }
            return 0;
        }

        @Override
        public Item getExpectedItem() {
            if (System.currentTimeMillis() % 2000L < 1000L) {
                return (Item)XU2Entries.filterFluids.value;
            }
            return (Item)XU2Entries.filterItems.value;
        }

        public boolean matches(IBuffer buffer) {
            switch (buffer.getBufferType()) {
                case FLUID: {
                    return this.matches(buffer.getFluid());
                }
                case ITEM: {
                    return this.matches(buffer.getItem());
                }
            }
            return false;
        }
    }

    public static class FluidFilter
    extends SingleStackHandlerFilter {
        public boolean matches(FluidStack stack) {
            ItemStack filterStack = this.getStack();
            if (StackHelper.isNull(filterStack)) {
                return true;
            }
            Item item = filterStack.func_77973_b();
            return item instanceof IFluidFilter && ((IFluidFilter)item).matches(filterStack, stack);
        }

        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            return item instanceof IFluidFilter && ((IFluidFilter)item).isFluidFilter(stack) ? stack.func_77976_d() : 0;
        }

        @Override
        public Item getExpectedItem() {
            return (Item)XU2Entries.filterFluids.value;
        }
    }
}

