/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetCustomJEIIngredient;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class WidgetFluidBase
extends WidgetBase
implements IWidgetServerNetwork,
IWidgetCustomJEIIngredient {
    public static final int[] ux2 = new int[]{18, 18, 18};
    public static final int[] uy2 = new int[]{0, 0, 0};
    public static final int[] uw2 = new int[]{7, 7, 7};
    public static final int[] ux = new int[]{32, 0, 50};
    public static final int[] uy = new int[]{0, 0, 0};
    public static final int[] uw = new int[]{18, 18, 18};
    public static final int[] uh = new int[]{33, 18, 65};
    FluidStack curFluid = null;
    int curCapacity = 0;
    int shape;
    int level;

    public WidgetFluidBase(int x, int y) {
        this(x, y, 0);
    }

    public WidgetFluidBase(int x, int y, int shape) {
        super(x, y, uw[shape], uh[shape]);
        this.shape = shape;
    }

    @Override
    public void addToDescription(XUPacketBuffer packet) {
        packet.writeFluidStack(this.getCurrentFluid());
        packet.writeInt(this.getCapacity());
    }

    protected abstract int getCapacity();

    protected abstract FluidStack getCurrentFluid();

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        this.curFluid = packet.readFluidStack();
        this.curCapacity = packet.readInt();
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curFluid != null && this.curFluid.getFluid() != null && this.curCapacity > 0) {
            int a = this.curFluid.amount * (this.getH() - 2) / this.curCapacity;
            gui.renderFluidTiled(this.curFluid, manager, guiLeft + this.getX() + 1, guiTop + this.getY() - 1 + this.getH() - a, this.getW() - 2, a);
        }
        manager.func_110577_a(gui.getWidgetTexture());
        gui.func_73729_b(guiLeft + this.getX() + this.getW() - uw2[this.shape] - 1, guiTop + this.getY() + 1, ux2[this.shape] + uw2[this.shape], uy2[this.shape], uw2[this.shape], this.getH() - 2);
        gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, ux2[this.shape], uy2[this.shape], uw2[this.shape], this.getH() - 2);
    }

    @Override
    public List<String> getToolTip() {
        if (this.curFluid == null || this.curFluid.getFluid() == null) {
            return ImmutableList.of((Object)Lang.translateArgs("%s of %s MB", 0, StringHelper.format(this.curCapacity)));
        }
        return ImmutableList.of((Object)this.curFluid.getLocalizedName(), (Object)Lang.translateArgs("%s of %s MB", StringHelper.format(this.curFluid.amount), StringHelper.format(this.curCapacity)));
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), ux[this.shape], uy[this.shape], uw[this.shape], uh[this.shape]);
    }

    @Override
    public Object getJEIIngredient() {
        return this.curFluid;
    }

    public static class Tank
    extends WidgetFluidBase {
        final IFluidTank fluidTank;

        public Tank(IFluidTank fluidTank, int x, int y, int shape) {
            super(x, y, shape);
            this.fluidTank = fluidTank;
        }

        @Override
        protected int getCapacity() {
            return this.fluidTank.getCapacity();
        }

        @Override
        protected FluidStack getCurrentFluid() {
            return this.fluidTank.getFluid();
        }
    }
}

