/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonBase;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonIcon;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public abstract class UpDownIntSelector
implements Iterable<WidgetBase> {
    final WidgetClickMCButtonBase up;
    final WidgetClickMCButtonBase down;
    final WidgetTextData text;

    public static int getOffset() {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            return 10;
        }
        return 1;
    }

    protected UpDownIntSelector(int x, int y, int w) {
        this.up = new WidgetClickMCButtonIcon(x + w / 2 - 9, y){

            @Override
            protected ItemStack getStack() {
                return ItemIngredients.Type.BUTTON_UP.newStack();
            }

            @Override
            @Nullable
            public XUPacketBuffer getPacketToSend(int mouseButton) {
                if (mouseButton == 0) {
                    XUPacketBuffer buffer = new XUPacketBuffer();
                    buffer.writeInt(UpDownIntSelector.this.getValue() + UpDownIntSelector.getOffset());
                    return buffer;
                }
                return null;
            }

            @Override
            public void receiveClientPacket(XUPacketBuffer buffer) {
                UpDownIntSelector.this.setValue(buffer.readInt());
            }
        };
        this.text = new WidgetTextData(x, y + 18 + 2, w, 9, 0, 0x404040){

            @Override
            public void addToDescription(XUPacketBuffer packet) {
                packet.writeInt(UpDownIntSelector.this.getValue());
            }

            @Override
            protected String constructText(XUPacketBuffer packet) {
                int newVal = packet.readInt();
                UpDownIntSelector.this.setValue(newVal);
                return StringHelper.format(newVal);
            }
        };
        this.down = new WidgetClickMCButtonIcon(x + w / 2 - 9, y + 4 + 18 + 9){

            @Override
            protected ItemStack getStack() {
                return ItemIngredients.Type.BUTTON_DOWN.newStack();
            }

            @Override
            @Nullable
            public XUPacketBuffer getPacketToSend(int mouseButton) {
                if (mouseButton == 0) {
                    XUPacketBuffer buffer = new XUPacketBuffer();
                    buffer.writeInt(UpDownIntSelector.this.getValue() - UpDownIntSelector.getOffset());
                    return buffer;
                }
                return null;
            }

            @Override
            public void receiveClientPacket(XUPacketBuffer buffer) {
                UpDownIntSelector.this.setValue(buffer.readInt());
            }
        };
    }

    public abstract int getValue();

    public abstract void setValue(int var1);

    @Override
    @Nonnull
    public Iterator<WidgetBase> iterator() {
        return Stream.of(this.up, this.down, this.text).iterator();
    }
}

