/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fluids;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidTankSerial
extends FluidTank
implements INBTSerializable<NBTTagCompound> {
    public FluidTankSerial(int capacity) {
        super(capacity);
    }

    public FluidTankSerial(FluidStack stack, int capacity) {
        super(stack, capacity);
    }

    public FluidTankSerial(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public boolean isEmpty() {
        return this.fluid == null || this.fluid.amount == 0;
    }

    protected void onChangeFill() {
        this.onChange();
    }

    protected void onChange() {
    }

    public int fill(FluidStack resource, boolean doFill) {
        int fill = super.fill(resource, doFill);
        if (doFill && fill != 0) {
            this.onChangeFill();
        }
        return fill;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drain = super.drain(maxDrain, doDrain);
        if (doDrain && drain != null) {
            this.onChangeDrain();
        }
        return drain;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drain = super.drain(resource, doDrain);
        if (doDrain && drain != null) {
            this.onChangeDrain();
        }
        return drain;
    }

    protected void onChangeDrain() {
        this.onChange();
    }

    public boolean isFull() {
        return this.fluid != null && this.fluid.amount >= this.capacity;
    }
}

