/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.entity;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.DataWatcherItemStack;
import com.rwtema.extrautils2.compatibility.EntityCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.enchants.BoomerangEnchantment;
import com.rwtema.extrautils2.items.ItemBoomerang;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import com.rwtema.extrautils2.utils.helpers.WorldHelper;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityBoomerang
extends Entity
implements IEntityAdditionalSpawnData,
IProjectile {
    public static final WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwners = new WeakHashMap();
    public static final WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwnersClient = ExtraUtils2.proxy.nullifyOnServer(new WeakHashMap());
    private static final DataParameter<Byte> DATAWATCHER_OUT_FLAG = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Rotations> DATAWATCHER_HOME = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187199_i);
    private static final DataParameter<Integer> DATAWATCHER_OWNER_ID = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataWatcherItemStack.Wrapper DATAWATCHER_STACK = new DataWatcherItemStack.Wrapper((DataParameter<ItemStack>)EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187196_f));
    int flyTime;
    int potionColor = 0;
    UUID owner = null;

    public EntityBoomerang(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70145_X = true;
    }

    public EntityBoomerang(World worldIn, double x, double y, double z, ItemStack stack, Object owner) {
        this(worldIn);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.setHome((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
        DataWatcherItemStack.setStack(this.field_70180_af, stack, DATAWATCHER_STACK);
        if (owner != null) {
            EntityBoomerang.getBoomerangOwners(worldIn).put(owner, new WeakReference<EntityBoomerang>(this));
        }
    }

    public EntityBoomerang(World worldIn, EntityLivingBase shooter, ItemStack stack) {
        this(worldIn);
        DataWatcherItemStack.setStack(this.field_70180_af, stack, DATAWATCHER_STACK);
        if (!(shooter instanceof EntityPlayer) || PlayerHelper.isPlayerReal((EntityPlayer)shooter)) {
            this.owner = shooter.func_110124_au();
        }
        if (worldIn.field_72995_K) {
            boomerangOwnersClient.put(shooter, new WeakReference<EntityBoomerang>(this));
        } else {
            boomerangOwners.put(shooter, new WeakReference<EntityBoomerang>(this));
        }
        Vec3d eyeVec = this.getEyeVec((Entity)shooter);
        this.func_70012_b(eyeVec.field_72450_a, eyeVec.field_72448_b, eyeVec.field_72449_c, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.25f * (1.0f + 0.3f * (float)this.getEnchantmentLevel(ItemBoomerang.SPEED)), 0.0f);
        this.setHome((float)eyeVec.field_72450_a, (float)eyeVec.field_72448_b, (float)eyeVec.field_72449_c);
    }

    public static WeakHashMap<Object, WeakReference<EntityBoomerang>> getBoomerangOwners(World worldIn) {
        return worldIn.field_72995_K ? boomerangOwnersClient : boomerangOwners;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 180.0 / Math.PI);
    }

    public void setHome(float x, float y, float z) {
        this.field_70180_af.func_187227_b(DATAWATCHER_HOME, (Object)new Rotations(x, y, z));
    }

    public Vec3d getHome() {
        Rotations rotations = (Rotations)this.field_70180_af.func_187225_a(DATAWATCHER_HOME);
        return new Vec3d((double)rotations.func_179415_b(), (double)rotations.func_179416_c(), (double)rotations.func_179413_d());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATAWATCHER_OUT_FLAG, (Object)0);
        this.field_70180_af.func_187214_a(DATAWATCHER_HOME, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        this.field_70180_af.func_187214_a(DATAWATCHER_OWNER_ID, (Object)-1);
        DataWatcherItemStack.register(this.field_70180_af, DATAWATCHER_STACK);
    }

    protected void func_70037_a(@Nonnull NBTTagCompound tag) {
        this.owner = tag.func_74764_b("Target_UUIDL") ? new UUID(tag.func_74763_f("Target_UUIDU"), tag.func_74763_f("Target_UUIDL")) : null;
        tag.func_74774_a("OutFlag", ((Byte)this.field_70180_af.func_187225_a(DATAWATCHER_OUT_FLAG)).byteValue());
        tag.func_74782_a("Home", (NBTBase)((Rotations)this.field_70180_af.func_187225_a(DATAWATCHER_HOME)).func_179414_a());
        tag.func_74768_a("Owner", ((Integer)this.field_70180_af.func_187225_a(DATAWATCHER_OWNER_ID)).intValue());
        ItemStack stack = DataWatcherItemStack.getStack(this.field_70180_af, DATAWATCHER_STACK);
        if (!StackHelper.isNonNull(stack)) {
            NBTTagCompound t = new NBTTagCompound();
            stack.func_77955_b(t);
            tag.func_74782_a("Stack", (NBTBase)t);
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound tag) {
        if (this.owner != null) {
            tag.func_74772_a("Target_UUIDL", this.owner.getLeastSignificantBits());
            tag.func_74772_a("Target_UUIDU", this.owner.getMostSignificantBits());
        }
        this.field_70180_af.func_187227_b(DATAWATCHER_OUT_FLAG, (Object)tag.func_74771_c("OutFlag"));
        this.field_70180_af.func_187227_b(DATAWATCHER_HOME, (Object)new Rotations(tag.func_150295_c("Home", 3)));
        this.field_70180_af.func_187227_b(DATAWATCHER_OWNER_ID, (Object)tag.func_74762_e("Owner"));
        DataWatcherItemStack.setStack(this.field_70180_af, StackHelper.loadFromNBT(tag.func_74775_l("Stack")), DATAWATCHER_STACK);
    }

    public int getEnchantmentLevel(BoomerangEnchantment enchantment) {
        ItemStack stack = DataWatcherItemStack.getStack(this.field_70180_af, DATAWATCHER_STACK);
        return StackHelper.isNonNull(stack) ? EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) : 0;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity owner = this.getOwner();
        boolean isRemote = this.field_70170_p.field_72995_K;
        Vec3d dest = this.calcTargetVec();
        ++this.flyTime;
        boolean returning = (Byte)this.field_70180_af.func_187225_a(DATAWATCHER_OUT_FLAG) != 0;
        Vec3d destDiff = dest.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float d = MathHelper.func_76133_a((double)(destDiff.field_72450_a * destDiff.field_72450_a + destDiff.field_72448_b * destDiff.field_72448_b + destDiff.field_72449_c * destDiff.field_72449_c));
        destDiff = destDiff.func_72432_b();
        double acceleration = (double)this.flyTime * 0.001 + (returning ? 0.05 : 0.0);
        if (returning) {
            acceleration *= (double)(1 + this.getEnchantmentLevel(ItemBoomerang.SPEED));
        }
        if ((double)d < 1.0E-4 && this.flyTime > 25 || acceleration > 1.0) {
            this.setMeDead();
            return;
        }
        this.field_70159_w *= 1.0 - acceleration;
        this.field_70181_x *= 1.0 - acceleration;
        this.field_70179_y *= 1.0 - acceleration;
        this.field_70159_w += destDiff.field_72450_a * acceleration;
        this.field_70181_x += destDiff.field_72448_b * acceleration;
        this.field_70179_y += destDiff.field_72449_c * acceleration;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 180.0 / Math.PI);
        if ((this.flyTime > 5 || returning) && MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) >= d) {
            this.func_70012_b(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, this.field_70177_z, this.field_70125_A);
            this.setMeDead();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            EntityCompat.move(this, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            HashSet prevPosSet = new HashSet();
            if (this.flyTime > 1) {
                Iterables.addAll(prevPosSet, this.getNeighbourBlocks());
            }
            EntityCompat.move(this, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            for (BlockPos newPos : this.getNeighbourBlocks()) {
                if (prevPosSet.contains(newPos)) continue;
                IBlockState blockState = this.field_70170_p.func_180495_p(newPos);
                Block block = blockState.func_177230_c();
                if (block == Blocks.field_150430_aB || block == Blocks.field_150471_bO || block == Blocks.field_150442_at) {
                    CompatHelper.activateBlock(block, this.field_70170_p, newPos, blockState, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_70170_p)), EnumHand.MAIN_HAND, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
                }
                if (this.getEnchantmentLevel(ItemBoomerang.DIGGING) <= 0 || !(block instanceof IPlantable) && !(block instanceof IShearable)) continue;
                block.func_176226_b(this.field_70170_p, newPos, blockState, 0);
                this.field_70170_p.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 3);
                WorldHelper.markBlockForUpdate(this.field_70170_p, newPos);
            }
        }
        ItemStack potionStack = DataWatcherItemStack.getStack(this.field_70180_af, DATAWATCHER_STACK);
        if (isRemote && !returning) {
            if (this.potionColor == -1) {
                List effectsFromStack;
                this.potionColor = StackHelper.isNonNull(potionStack) ? ((effectsFromStack = PotionUtils.func_185189_a((ItemStack)potionStack)).isEmpty() ? 0 : PotionUtils.func_185181_a((Collection)effectsFromStack)) : 0;
            }
            double dx = this.field_70165_t - this.field_70169_q;
            double dy = this.field_70163_u - this.field_70167_r;
            double dz = this.field_70161_v - this.field_70166_s;
            for (int k = 0; k < 4; ++k) {
                double t = (double)k / 4.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + dx * t, this.field_70163_u + dy * t, this.field_70161_v + dz * t, -dx, -dy + 0.2, -dz, new int[0]);
            }
            if (this.potionColor != 0) {
                double d0 = (double)(this.potionColor >> 16 & 0xFF) / 255.0;
                double d1 = (double)(this.potionColor >> 8 & 0xFF) / 255.0;
                double d2 = (double)(this.potionColor & 0xFF) / 255.0;
                for (int j = 0; j < 3; ++j) {
                    double t = (double)j / 3.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + dx * t, this.field_70163_u + dy * t, this.field_70161_v + dz * t, d0, d1, d2, new int[0]);
                }
            }
        }
        Vec3d startVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d endVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(startVec, endVec, false, true, false);
        if (!isRemote) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = -1.0;
            for (Entity e : list) {
                double d1;
                if (e instanceof EntityItem || e instanceof EntityXPOrb) {
                    if (e.func_184187_bx() != null) continue;
                    this.addItem(e);
                    continue;
                }
                if (returning || !e.func_70067_L() || this.isOwner(e)) continue;
                if (e instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)e;
                    if (entityplayer.field_71075_bZ.field_75102_a || owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a(entityplayer)) continue;
                }
                float f1 = 0.3f;
                AxisAlignedBB axisAlignedBB = e.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                RayTraceResult mop = axisAlignedBB.func_72327_a(startVec, endVec);
                if (mop == null || !((d1 = startVec.func_72436_e(mop.field_72307_f)) < d0) && d0 != -1.0) continue;
                entity = e;
                d0 = d1;
            }
            if (!returning && entity != null && entity.func_70097_a((DamageSource)new DamageSourceBoomerang(this, owner), 4.0f + (float)(4 * this.getEnchantmentLevel(ItemBoomerang.SHARPNESS))) && entity instanceof EntityLivingBase && !(entity instanceof EntityEnderman)) {
                int flame;
                int boom;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70180_af.func_187227_b(DATAWATCHER_OUT_FLAG, (Object)1);
                returning = true;
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                if (owner instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)owner);
                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)owner), (Entity)entitylivingbase);
                }
                if (StackHelper.isNonNull(potionStack)) {
                    List potionEffects = PotionUtils.func_185189_a((ItemStack)potionStack);
                    for (PotionEffect potionEffect : potionEffects) {
                        if (potionEffect.func_188419_a().func_76403_b()) {
                            potionEffect.func_188419_a().func_180793_a((Entity)this, owner, entitylivingbase, potionEffect.func_76458_c(), 0.25);
                            continue;
                        }
                        entitylivingbase.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b() / 8, potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
                    }
                }
                if ((boom = this.getEnchantmentLevel(ItemBoomerang.EXPLODE)) > 0) {
                    this.field_70170_p.func_72876_a(owner, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)boom, false);
                }
                if ((flame = this.getEnchantmentLevel(ItemBoomerang.FLAMING)) > 0) {
                    entity.func_70015_d(5);
                }
                if (owner != null && entity != owner && entity instanceof EntityPlayer && owner instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)owner).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                }
            }
        }
        if (movingobjectposition != null) {
            int boom;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70180_af.func_187227_b(DATAWATCHER_OUT_FLAG, (Object)1);
            if (!returning && !this.field_70170_p.field_72995_K && (boom = this.getEnchantmentLevel(ItemBoomerang.EXPLODE)) > 0) {
                Random rand = this.field_70170_p.field_73012_v;
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t + rand.nextGaussian() * 0.1, this.field_70163_u + rand.nextGaussian() * 0.1, this.field_70161_v + rand.nextGaussian() * 0.1, (float)boom, false);
            }
        }
    }

    public void addItem(Entity entity) {
        if (this.field_70128_L || entity == null || entity.field_70128_L) {
            return;
        }
        EntityItem entityItem = entity instanceof EntityItem ? (EntityItem)entity : null;
        EntityXPOrb xp = entity instanceof EntityXPOrb ? (EntityXPOrb)entity : null;
        for (Entity checkEntity : this.func_184188_bt()) {
            if (entityItem != null && checkEntity instanceof EntityItem && this.combine(entityItem, (EntityItem)checkEntity)) {
                this.field_70170_p.func_72900_e((Entity)entityItem);
                return;
            }
            if (xp == null || !(checkEntity instanceof EntityXPOrb)) continue;
            ((EntityXPOrb)checkEntity).field_70530_e += xp.field_70530_e;
            this.field_70170_p.func_72900_e((Entity)xp);
            return;
        }
        entity.func_184220_m((Entity)this);
    }

    public boolean combine(EntityItem adding, EntityItem current) {
        if (adding == current) {
            return true;
        }
        if (!adding.func_70089_S() || !current.func_70089_S()) {
            return true;
        }
        ItemStack addingStack = adding.func_92059_d();
        ItemStack currentStack = current.func_92059_d();
        if (StackHelper.isNull(addingStack) || StackHelper.isNull(currentStack)) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)addingStack, (ItemStack)currentStack)) {
            return false;
        }
        int allowedAmount = currentStack.func_77976_d() - StackHelper.getStacksize(currentStack);
        if (allowedAmount == 0) {
            return false;
        }
        int toAdd = StackHelper.getStacksize(addingStack);
        if (toAdd <= allowedAmount) {
            StackHelper.decrease(addingStack, toAdd);
            adding.func_92058_a(addingStack);
            StackHelper.increase(currentStack, toAdd);
            current.func_92058_a(currentStack);
            return true;
        }
        StackHelper.decrease(addingStack, allowedAmount);
        adding.func_92058_a(addingStack);
        StackHelper.increase(currentStack, allowedAmount);
        current.func_92058_a(currentStack);
        return false;
    }

    public void setMeDead() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.func_184226_ay();
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Nonnull
    public Iterable<BlockPos> getNeighbourBlocks() {
        AxisAlignedBB expand = this.func_174813_aQ();
        return BlockPos.func_177980_a((BlockPos)new BlockPos(MathHelper.func_76128_c((double)expand.field_72340_a), MathHelper.func_76128_c((double)expand.field_72338_b), MathHelper.func_76128_c((double)expand.field_72339_c)), (BlockPos)new BlockPos(MathHelper.func_76143_f((double)expand.field_72336_d), MathHelper.func_76143_f((double)expand.field_72337_e), MathHelper.func_76143_f((double)expand.field_72334_f)));
    }

    public boolean isOwner(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            int i = (Integer)this.field_70180_af.func_187225_a(DATAWATCHER_OWNER_ID);
            return entity.func_145782_y() == i;
        }
        return this.owner != null && this.owner.equals(entity.func_110124_au());
    }

    public Entity getOwner() {
        WeakReference<EntityBoomerang> reference;
        WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwners;
        Entity entity;
        if (this.field_70170_p.field_72995_K) {
            int i = (Integer)this.field_70180_af.func_187225_a(DATAWATCHER_OWNER_ID);
            entity = this.field_70170_p.func_73045_a(i);
            boomerangOwners = boomerangOwnersClient;
        } else {
            if (this.owner == null) {
                return null;
            }
            entity = ((WorldServer)this.field_70170_p).func_175733_a(this.owner);
            boomerangOwners = EntityBoomerang.boomerangOwners;
        }
        if (entity != null && ((reference = boomerangOwners.get(entity)) == null || reference.get() == null)) {
            boomerangOwners.put(entity, new WeakReference<EntityBoomerang>(this));
        }
        return entity;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            boomerangOwnersClient.remove(this.getOwner());
        } else {
            boomerangOwners.remove(this.getOwner());
        }
    }

    public Vec3d calcTargetVec() {
        if (this.field_70170_p.field_72995_K) {
            Entity entity;
            int i = (Integer)this.field_70180_af.func_187225_a(DATAWATCHER_OWNER_ID);
            if (i != -1 && (entity = this.field_70170_p.func_73045_a(i)) != null) {
                return this.getEyeVec(entity);
            }
        } else {
            Entity entity;
            if (this.owner != null && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.owner)) != null) {
                this.field_70180_af.func_187227_b(DATAWATCHER_OWNER_ID, (Object)entity.func_145782_y());
                Vec3d eyeVec = this.getEyeVec(entity);
                this.setHome((float)eyeVec.field_72450_a, (float)eyeVec.field_72448_b, (float)eyeVec.field_72449_c);
                return eyeVec;
            }
            this.field_70180_af.func_187227_b(DATAWATCHER_OWNER_ID, (Object)-1);
        }
        return this.getHome();
    }

    @Nonnull
    public Vec3d getEyeVec(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() * 0.8, entity.field_70161_v);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.flyTime);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == EntityBoomerang.DATAWATCHER_STACK.wrapper) {
            this.potionColor = -1;
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.flyTime = additionalData.readInt();
    }

    public class DamageSourceBoomerang
    extends EntityDamageSourceIndirect {
        public DamageSourceBoomerang(EntityBoomerang indirectEntityIn, Entity owner) {
            super("boomerang", (Entity)indirectEntityIn, owner);
        }
    }
}

