/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.compatibility.XUShapedRecipe;
import com.rwtema.extrautils2.gui.backend.WidgetCraftingMatrix;
import com.rwtema.extrautils2.utils.datastructures.ConcatList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CraftingHelper112 {
    public static List<IRecipe> getRecipeList() {
        return ForgeRegistries.RECIPES.getValues();
    }

    public static Object[] getShapedIngredientRecipes(Object ... recipes) {
        for (int i = 0; i < recipes.length; ++i) {
            IBlockState state;
            Block block;
            Item itemDropped;
            ItemStack stack;
            Object in;
            Object result = in = recipes[i];
            if (in instanceof ItemStack) {
                stack = (ItemStack)in;
                Item item = stack.func_77973_b();
                ICustomRecipeMatching matching = null;
                if (item instanceof ICustomRecipeMatching) {
                    matching = (ICustomRecipeMatching)item;
                } else if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof ICustomRecipeMatching) {
                    matching = (ICustomRecipeMatching)((ItemBlock)item).func_179223_d();
                }
                if (matching != null) {
                    final ICustomRecipeMatching finalMatching = matching;
                    result = new Ingredient(new ItemStack[]{stack}){

                        public boolean apply(@Nullable ItemStack input) {
                            return finalMatching.itemsMatch(input, stack);
                        }
                    };
                }
            } else if (in instanceof ICustomRecipeMatching) {
                if (in instanceof Item) {
                    stack = new ItemStack((Item)in);
                } else if (in instanceof Block) {
                    stack = new ItemStack((Block)in);
                } else {
                    throw new IllegalArgumentException();
                }
                result = new Ingredient(new ItemStack[]{stack}){

                    public boolean apply(@Nullable ItemStack input) {
                        return ((ICustomRecipeMatching)in).itemsMatch(input, stack);
                    }
                };
            } else if (in instanceof List) {
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                XUShapedRecipe.handleListInput(stackList, in);
                result = new Ingredient(stackList.toArray(new ItemStack[stackList.size()])){};
            } else if (in instanceof IItemStackMaker) {
                result = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((IItemStackMaker)in).newStack()});
            } else if (in instanceof IBlockState && (itemDropped = (block = (state = (IBlockState)in).func_177230_c()).func_180660_a(state, null, 0)) != StackHelper.nullItem()) {
                result = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(itemDropped, 1, block.func_180651_a(state))});
            }
            recipes[i] = result;
        }
        return recipes;
    }

    public static Object getRecipeObject(Object in) {
        ConcatList<ItemStack> list = new ConcatList<ItemStack>();
        XUShapedRecipe.handleListInput(list, in);
        Object out = list.subLists.size() == 1 ? (list.size() == 1 ? list.modifiableList.get(0) : list.modifiableList) : (list.subLists.size() == 2 && list.modifiableList.isEmpty() ? list.subLists.get(1) : list);
        return out;
    }

    public static ItemStack getMatchingResult(WidgetCraftingMatrix widgetCraftingMatrix, EntityPlayer player) {
        return CraftingManager.func_82787_a((InventoryCrafting)widgetCraftingMatrix.crafter, (World)player.field_70170_p);
    }

    @Nonnull
    public static List<Object> getRecipeInputs(IRecipe curRecipe) {
        ArrayList<Object> input = new ArrayList<Object>();
        if (curRecipe instanceof IShapedRecipe) {
            IShapedRecipe recipe = (IShapedRecipe)curRecipe;
            NonNullList inputs = recipe.func_192400_c();
            int w = recipe.getRecipeWidth();
            int h = recipe.getRecipeHeight();
            Object[] inputs3x3 = new Object[9];
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    inputs3x3[x + y * 3] = inputs.get(x + y * w);
                }
            }
            Collections.addAll(input, inputs3x3);
        } else {
            input.addAll((Collection<Object>)curRecipe.func_192400_c());
        }
        return input;
    }

    public static Object unwrapIngredients(Object o) {
        if (o instanceof Ingredient) {
            Object[] matchingStacks = ((Ingredient)o).func_193365_a();
            return Lists.newArrayList((Object[])matchingStacks);
        }
        return o;
    }
}

