/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOneWay
extends XUBlockStatic {
    public BlockOneWay() {
        super(Material.field_151592_s);
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == base_state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
    }

    @Override
    @Nonnull
    public IBlockState xuOnBlockPlacedBase(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_ALL, (Comparable)FacingHelper.getDirectionFromEntityLiving(pos, placer));
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return super.func_149637_q(state);
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return super.func_149721_r(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.isNormalCube(state, world, pos);
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addWorldPropertyWithDefault(XUBlockStateCreator.ROTATION_ALL, EnumFacing.NORTH).build();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = BoxModel.newStandardBlock(false);
        model.addBoxI(0, 0, 0, 16, 16, 16).setTexture("strange_glass_one_way_side").setTextureSides(EnumFacing.DOWN, "strange_glass_one_way", EnumFacing.UP, "strange_glass_one_way_opening").setInvisible(EnumFacing.UP);
        model.addBox(0.0f, 9.765625E-4f, 0.0f, 1.0f, 9.765625E-4f, 1.0f).setTextureSides(EnumFacing.UP, "strange_glass_one_way_reverse").setInvisible(EnumFacing.DOWN);
        model.setLayer(BlockRenderLayer.CUTOUT);
        model.renderAsNormalBlock = false;
        return model.rotateToSide((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState otherState = blockAccess.func_180495_p(pos.func_177972_a(side));
        return (otherState != blockState || blockState.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL) == side) && !otherState.doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public void addCollisionBoxToListBase(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        if (entityIn != null) {
            AxisAlignedBB aabb = entityIn.func_174813_aQ();
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
            double v = FacingHelper.aabbGetters.get(facing.func_176734_d()).applyAsDouble(aabb);
            int vi = FacingHelper.blockPosGetters.get(facing.func_176740_k()).applyAsInt(pos);
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)vi < v : (double)(vi + 1) > v) {
                return;
            }
            AxisAlignedBB bb = Block.field_185505_j.func_186670_a(pos);
            if (bb.func_72326_a(entityBox)) {
                collidingBoxes.add(bb);
            }
        }
    }
}

