/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.recipes.GenericMachineRecipe;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.List;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    public static void handle(FMLInterModComms.IMCMessage message) {
        try {
            ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(message.getSender());
            switch (message.key) {
                case "addMachineRecipe": {
                    IMCHandler.addMachineRecipe(message.getNBTValue(), modContainer);
                    break;
                }
                case "addMachine": {
                    IMCHandler.addMachine(message.getNBTValue(), modContainer);
                }
            }
        }
        catch (Throwable err) {
            CrashReport report = new CrashReport("Error while processing IMC message from sender " + message.getSender(), err);
            report.func_85058_a("Sender").func_71507_a("ModID", (Object)message.getSender());
            CrashReportCategory category = report.func_85058_a("IMC Message");
            category.func_71507_a("Message Key", (Object)message.key);
            category.func_71507_a("Message Type", (Object)message.getMessageType().toString());
            category.func_189529_a("Message", () -> {
                if (message.isStringMessage()) {
                    return message.getStringValue();
                }
                if (message.isItemStackMessage()) {
                    return message.getItemStackValue().toString();
                }
                if (message.isNBTMessage()) {
                    return message.getNBTValue().toString();
                }
                if (message.isResourceLocationMessage()) {
                    return message.getResourceLocationValue().toString();
                }
                if (message.isFunctionMessage()) {
                    return "Function:[" + message.getMessageType() + "]";
                }
                throw new IllegalArgumentException(message + " is not supported");
            });
            throw new ReportedException(report);
        }
    }

    public static void addMachine(NBTTagCompound tag, ModContainer modContainer) {
        String machine = tag.func_74779_i("machine");
        String energy_mode = tag.func_74779_i(tag.func_74779_i("energy_mode")).toUpperCase();
        Machine.EnergyMode energyMode = Machine.EnergyMode.valueOf(energy_mode);
        int energyBufferSize = tag.func_74762_e("energy_buffer");
        int energyTransferLimit = tag.func_74762_e("energy_transfer");
        int color = tag.func_74764_b("color") ? tag.func_74762_e("color") : 0xFFFFFF;
        String textureTop = NBTHelper.getStringOrNull(tag, "texture_top");
        String textureTopOverlay = NBTHelper.getStringOrNull(tag, "texture_top_overlay");
        String textureBase = NBTHelper.getStringOrNull(tag, "texture_base");
        String textureBottom = NBTHelper.getStringOrNull(tag, "texture_bottom");
        String frontTexture = tag.func_74779_i("texture_front_off");
        String frontTextureActive = tag.func_74779_i("texture_front_on");
        List<MachineSlotItem> itemInputs = NBTHelper.processList(NBTHelper.getTagListAnyType(tag, "item_inputs"), IMCHandler::getItemSlot);
        List<MachineSlotItem> itemOutputs = NBTHelper.processList(NBTHelper.getTagListAnyType(tag, "item_outputs"), IMCHandler::getItemSlot);
        List<MachineSlotFluid> fluidInputs = NBTHelper.processList(NBTHelper.getTagListAnyType(tag, "fluid_inputs"), IMCHandler::getFluidSlot);
        List<MachineSlotFluid> fluidOutputs = NBTHelper.processList(NBTHelper.getTagListAnyType(tag, "fluid_outputs"), IMCHandler::getFluidSlot);
        Machine actualMachine = new Machine(machine, energyBufferSize, energyTransferLimit, itemInputs, fluidInputs, itemOutputs, fluidOutputs, frontTexture, frontTextureActive, energyMode, color, textureTop, textureBase, textureBottom, textureTopOverlay);
        if (tag.func_150297_b("default_energy", 99)) {
            actualMachine.defaultEnergy = tag.func_74762_e("default_energy");
        }
        if (tag.func_150297_b("default_time", 99)) {
            actualMachine.defaultProcessingTime = tag.func_74762_e("default_time");
        }
        MachineRegistry.register(actualMachine, modContainer);
    }

    public static MachineSlotItem getItemSlot(NBTBase base) {
        if (base.func_74732_a() == 8) {
            return new MachineSlotItem(((NBTTagString)base).func_150285_a_());
        }
        NBTTagCompound nbt = (NBTTagCompound)base;
        String name = nbt.func_74779_i("name");
        boolean optional = nbt.func_74767_n("optional");
        int capacity = nbt.func_74764_b("capacity") ? nbt.func_74762_e("capacity") : 64;
        int col = nbt.func_74764_b("color") ? nbt.func_74762_e("color") : -1;
        String texture = NBTHelper.getStringOrNull(nbt, "background_texture");
        return new MachineSlotItem(name, col, optional, texture, capacity);
    }

    public static MachineSlotFluid getFluidSlot(NBTBase base) {
        if (base.func_74732_a() == 8) {
            return new MachineSlotFluid(((NBTTagString)base).func_150285_a_());
        }
        NBTTagCompound nbt = (NBTTagCompound)base;
        String name = nbt.func_74779_i("name");
        boolean optional = nbt.func_74767_n("optional");
        int capacity = nbt.func_74764_b("capacity") ? nbt.func_74762_e("capacity") : 64;
        int col = nbt.func_74764_b("color") ? nbt.func_74762_e("color") : -1;
        FluidStack filterstack = nbt.func_74764_b("fluid_filter") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_filter")) : null;
        return new MachineSlotFluid(name, capacity, col, optional, filterstack);
    }

    public static void addMachineRecipe(NBTTagCompound tag, ModContainer modContainer) {
        List<Object> list;
        ItemStack stack;
        NBTBase base;
        int amount;
        String name;
        String machineKey = tag.func_74779_i("machine");
        Machine machine = MachineRegistry.getMachine(machineKey);
        if (machine == null) {
            return;
        }
        GenericMachineRecipe.Builder builder = new GenericMachineRecipe.Builder(machine);
        boolean hasEnergy = tag.func_150297_b("energy", 99);
        boolean hasRF = tag.func_150297_b("rf_rate", 99);
        boolean hasProcessingTime = tag.func_150297_b("time", 99);
        int energy = tag.func_74762_e("energy");
        float rf = tag.func_74760_g("rf_rate");
        int time = tag.func_74762_e("time");
        if (hasEnergy && hasProcessingTime) {
            builder.setEnergy(energy).setProcessingTime(time);
        } else if (hasEnergy && hasRF) {
            builder.setRFRate(energy, rf);
        } else if (hasProcessingTime && hasRF) {
            builder.setEnergy((int)Math.ceil((float)time * rf));
            builder.setProcessingTime(time);
        } else {
            if (hasEnergy) {
                builder.setEnergy(energy);
            }
            if (hasProcessingTime) {
                builder.setProcessingTime(time);
            }
        }
        Iterable allSlots = Iterables.concat(machine.itemInputs, machine.itemOutputs, machine.fluidInputs, machine.fluidOutputs);
        for (MachineSlot slot : allSlots) {
            if (!slot.optional && !tag.func_74764_b(slot.name)) {
                throw new IllegalArgumentException("Missing slot " + slot.name + " in tag " + tag.toString());
            }
            if (!tag.func_74764_b(slot.name + "_probability")) continue;
            builder.setProbability(slot, tag.func_74760_g(slot.name + "_probability"));
        }
        for (MachineSlot slot : machine.itemInputs) {
            name = ((MachineSlotItem)slot).name;
            if (!tag.func_74764_b(name)) continue;
            amount = -1;
            if (tag.func_150297_b(name + "_amount", 99)) {
                amount = tag.func_74762_e(name + "_amount");
            }
            if ((base = tag.func_74781_a(name)).func_74732_a() == 8) {
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setItemInput((MachineSlotItem)slot, ((NBTTagString)base).func_150285_a_(), amount);
                continue;
            }
            if (base.func_74732_a() == 10) {
                stack = StackHelper.loadFromNBT((NBTTagCompound)base);
                if (amount == -1) {
                    amount = StackHelper.getStacksize(stack);
                }
                builder.setItemInput((MachineSlotItem)slot, stack, amount);
                continue;
            }
            if (base.func_74732_a() == 9) {
                list = NBTHelper.getItemStackRecipeEntry(base);
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setItemInput((MachineSlotItem)slot, list, amount);
                continue;
            }
            throw new IllegalArgumentException("Unable to process Item Input " + base);
        }
        for (MachineSlot slot : machine.itemOutputs) {
            name = ((MachineSlotItem)slot).name;
            if (!tag.func_74764_b(name)) continue;
            amount = -1;
            if (tag.func_150297_b(name + "_amount", 99)) {
                amount = tag.func_74762_e(name + "_amount");
            }
            if ((base = tag.func_74781_a(name)).func_74732_a() == 8) {
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setItemOutput((MachineSlotItem)slot, ((NBTTagString)base).func_150285_a_(), amount);
                continue;
            }
            if (base.func_74732_a() == 10) {
                stack = StackHelper.loadFromNBT((NBTTagCompound)base);
                if (amount == -1) {
                    amount = StackHelper.getStacksize(stack);
                }
                builder.setItemOutput((MachineSlotItem)slot, stack, amount);
                continue;
            }
            if (base.func_74732_a() == 9) {
                list = NBTHelper.getItemStackRecipeEntry(base);
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setItemOutput((MachineSlotItem)slot, list, amount);
                continue;
            }
            throw new IllegalArgumentException("Unable to process Item Output " + base);
        }
        for (MachineSlot slot : machine.fluidInputs) {
            name = ((MachineSlotFluid)slot).name;
            if (!tag.func_74764_b(name)) continue;
            amount = -1;
            if (tag.func_150297_b(name + "_amount", 99)) {
                amount = tag.func_74762_e(name + "_amount");
            }
            if ((base = tag.func_74781_a(name)).func_74732_a() == 8) {
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setFluidInputFluidName((MachineSlotFluid)slot, ((NBTTagString)base).func_150285_a_(), amount);
                continue;
            }
            if (base.func_74732_a() == 10) {
                stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)base));
                if (amount == -1) {
                    amount = stack.amount;
                }
                builder.setFluidInputFluidStack((MachineSlotFluid)slot, (FluidStack)stack, amount);
                continue;
            }
            if (base.func_74732_a() == 9) {
                list = NBTHelper.getFluidStackRecipeEntry(base);
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setFluidInputFluidNameList((MachineSlotFluid)slot, list, amount);
                continue;
            }
            throw new IllegalArgumentException("Unable to process Fluid Input " + base);
        }
        for (MachineSlot slot : machine.fluidOutputs) {
            name = ((MachineSlotFluid)slot).name;
            if (!tag.func_74764_b(name)) continue;
            amount = -1;
            if (tag.func_150297_b(name + "_amount", 99)) {
                amount = tag.func_74762_e(name + "_amount");
            }
            if ((base = tag.func_74781_a(name)).func_74732_a() == 8) {
                if (amount == -1) {
                    throw new IllegalArgumentException("Unspecified amount");
                }
                builder.setFluidOutput((MachineSlotFluid)slot, ((NBTTagString)base).func_150285_a_(), amount);
                continue;
            }
            if (base.func_74732_a() == 10) {
                stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)base));
                if (amount == -1) {
                    amount = stack.amount;
                }
                builder.setFluidOutput((MachineSlotFluid)slot, (FluidStack)stack, amount);
                continue;
            }
            throw new IllegalArgumentException("Unable to process Fluid Output " + base);
        }
        machine.recipes_registry.addRecipe(builder.build(), modContainer);
    }
}

