/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.gui;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.client.gui.ButtonAction;
import mod.chiselsandbits.client.gui.SpriteIconPositioning;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.modes.IToolMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.model.ModelLoader;

public class ChiselsAndBitsMenu
extends GuiScreen {
    private final float TIME_SCALE = 0.01f;
    public static final ChiselsAndBitsMenu instance = new ChiselsAndBitsMenu();
    private float visibility = 0.0f;
    private Stopwatch lastChange = Stopwatch.createStarted();
    public IToolMode switchTo = null;
    public ButtonAction doAction = null;
    public boolean actionUsed = false;

    private float clampVis(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    public void raiseVisibility() {
        this.visibility = this.clampVis(this.visibility + (float)this.lastChange.elapsed(TimeUnit.MILLISECONDS) * 0.01f);
        this.lastChange = Stopwatch.createStarted();
    }

    public void decreaseVisibility() {
        this.visibility = this.clampVis(this.visibility - (float)this.lastChange.elapsed(TimeUnit.MILLISECONDS) * 0.01f);
        this.lastChange = Stopwatch.createStarted();
    }

    public boolean isVisible() {
        return (double)this.visibility > 0.001;
    }

    public void configure(int scaledWidth, int scaledHeight) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.field_146294_l = scaledWidth;
        this.field_146295_m = scaledHeight;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        double y;
        double x;
        ChiselToolType tool = ClientSide.instance.getHeldToolType(EnumHand.MAIN_HAND);
        if (tool == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        int start = (int)(this.visibility * 98.0f) << 24;
        int end = (int)(this.visibility * 128.0f) << 24;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, start, end);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double vecX = mouseX - this.field_146294_l / 2;
        double vecY = mouseY - this.field_146295_m / 2;
        double radians = Math.atan2(vecY, vecX);
        double ring_inner_edge = 20.0;
        double ring_outer_edge = 50.0;
        double text_distnace = 65.0;
        double quarterCircle = 1.5707963267948966;
        if (radians < -1.5707963267948966) {
            radians += Math.PI * 2;
        }
        double middle_x = this.field_146294_l / 2;
        double middle_y = this.field_146295_m / 2;
        ArrayList<MenuRegion> modes = new ArrayList<MenuRegion>();
        ArrayList<MenuButton> btns = new ArrayList<MenuButton>();
        if (tool == ChiselToolType.BIT) {
            if (ChiselsAndBits.getConfig().replaceingBits) {
                btns.add(new MenuButton(LocalStrings.BitOptionReplace.toString(), ButtonAction.REPLACE_TOGGLE, 65.0, -44.0, ClientSide.swapIcon, EnumFacing.EAST));
            } else {
                btns.add(new MenuButton(LocalStrings.BitOptionPlace.toString(), ButtonAction.REPLACE_TOGGLE, 65.0, -44.0, ClientSide.placeIcon, EnumFacing.EAST));
            }
        }
        btns.add(new MenuButton("mod.chiselsandbits.other.undo", ButtonAction.UNDO, 65.0, -20.0, ClientSide.undoIcon, EnumFacing.EAST));
        btns.add(new MenuButton("mod.chiselsandbits.other.redo", ButtonAction.REDO, 65.0, 4.0, ClientSide.redoIcon, EnumFacing.EAST));
        if (tool == ChiselToolType.CHISELED_BLOCK || tool == ChiselToolType.NEGATIVEPATTERN || tool == ChiselToolType.POSITIVEPATTERN) {
            btns.add(new MenuButton("mod.chiselsandbits.other.roll_x", ButtonAction.ROLL_X, -83.0, -20.0, ClientSide.roll_x, EnumFacing.WEST));
            btns.add(new MenuButton("mod.chiselsandbits.other.roll_z", ButtonAction.ROLL_Z, -83.0, 4.0, ClientSide.roll_z, EnumFacing.WEST));
        }
        if (tool == ChiselToolType.TAPEMEASURE) {
            int colorSize = EnumDyeColor.values().length / 4 * 24 - 4;
            double underring = -84.0;
            double bntPos = -colorSize;
            int bntSize = 24;
            EnumFacing textSide = EnumFacing.UP;
            for (EnumDyeColor color : EnumDyeColor.values()) {
                ButtonAction action = ButtonAction.valueOf(color.name());
                if (bntPos > (double)colorSize) {
                    underring = 50.0;
                    bntPos = -colorSize;
                    textSide = EnumFacing.DOWN;
                }
                btns.add(new MenuButton("chiselsandbits.color." + color.func_176762_d(), action, bntPos, underring, color.func_193350_e(), textSide));
                bntPos += 24.0;
            }
        }
        for (IToolMode mode : tool.getAvailableModes()) {
            if (mode.isDisabled()) continue;
            modes.add(new MenuRegion(mode));
        }
        this.switchTo = null;
        this.doAction = null;
        if (!modes.isEmpty()) {
            int totalModes = Math.max(3, modes.size());
            int currentMode = 0;
            double fragment = 0.015707963267948967;
            double fragment2 = 0.007853981633974483;
            double perObject = Math.PI * 2 / (double)totalModes;
            for (MenuRegion mnuRgn : modes) {
                boolean quad;
                double begin_rad = (double)currentMode * perObject - 1.5707963267948966;
                double end_rad = (double)(currentMode + 1) * perObject - 1.5707963267948966;
                mnuRgn.x1 = Math.cos(begin_rad);
                mnuRgn.x2 = Math.cos(end_rad);
                mnuRgn.y1 = Math.sin(begin_rad);
                mnuRgn.y2 = Math.sin(end_rad);
                double x1m1 = Math.cos(begin_rad + 0.015707963267948967) * 20.0;
                double x2m1 = Math.cos(end_rad - 0.015707963267948967) * 20.0;
                double y1m1 = Math.sin(begin_rad + 0.015707963267948967) * 20.0;
                double y2m1 = Math.sin(end_rad - 0.015707963267948967) * 20.0;
                double x1m2 = Math.cos(begin_rad + 0.007853981633974483) * 50.0;
                double x2m2 = Math.cos(end_rad - 0.007853981633974483) * 50.0;
                double y1m2 = Math.sin(begin_rad + 0.007853981633974483) * 50.0;
                double y2m2 = Math.sin(end_rad - 0.007853981633974483) * 50.0;
                float a = 0.5f;
                float f = 0.0f;
                boolean bl = quad = this.inTriangle(x1m1, y1m1, x2m2, y2m2, x2m1, y2m1, vecX, vecY) || this.inTriangle(x1m1, y1m1, x1m2, y1m2, x2m2, y2m2, vecX, vecY);
                if (begin_rad <= radians && radians <= end_rad && quad) {
                    f = 1.0f;
                    mnuRgn.highlighted = true;
                    this.switchTo = mnuRgn.mode;
                }
                buffer.func_181662_b(middle_x + x1m1, middle_y + y1m1, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
                buffer.func_181662_b(middle_x + x2m1, middle_y + y2m1, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
                buffer.func_181662_b(middle_x + x2m2, middle_y + y2m2, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
                buffer.func_181662_b(middle_x + x1m2, middle_y + y1m2, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
                ++currentMode;
            }
        }
        for (MenuButton btn : btns) {
            float a = 0.5f;
            float f = 0.0f;
            if (btn.x1 <= vecX && btn.x2 >= vecX && btn.y1 <= vecY && btn.y2 >= vecY) {
                f = 1.0f;
                btn.highlighted = true;
                this.doAction = btn.action;
            }
            buffer.func_181662_b(middle_x + btn.x1, middle_y + btn.y1, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
            buffer.func_181662_b(middle_x + btn.x1, middle_y + btn.y2, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
            buffer.func_181662_b(middle_x + btn.x2, middle_y + btn.y2, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
            buffer.func_181662_b(middle_x + btn.x2, middle_y + btn.y1, (double)this.field_73735_i).func_181666_a(f, f, f, 0.5f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (MenuRegion mnuRgn : modes) {
            x = (mnuRgn.x1 + mnuRgn.x2) * 0.5 * 38.0;
            y = (mnuRgn.y1 + mnuRgn.y2) * 0.5 * 38.0;
            SpriteIconPositioning sip = ClientSide.instance.getIconForMode(mnuRgn.mode);
            double scalex = 15.0 * sip.width * 0.5;
            double scaley = 15.0 * sip.height * 0.5;
            double x1 = x - scalex;
            double x2 = x + scalex;
            double y1 = y - scaley;
            double y2 = y + scaley;
            TextureAtlasSprite sprite = sip.sprite;
            float f = 1.0f;
            float a = 1.0f;
            double u1 = sip.left * 16.0;
            double u2 = (sip.left + sip.width) * 16.0;
            double v1 = sip.top * 16.0;
            double v2 = (sip.top + sip.height) * 16.0;
            buffer.func_181662_b(middle_x + x1, middle_y + y1, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(u1), (double)sprite.func_94207_b(v1)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + x1, middle_y + y2, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(u1), (double)sprite.func_94207_b(v2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + x2, middle_y + y2, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(u2), (double)sprite.func_94207_b(v2)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + x2, middle_y + y1, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(u2), (double)sprite.func_94207_b(v1)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        for (MenuButton btn : btns) {
            float f = this.switchTo == null ? 1.0f : 0.5f;
            float a = 1.0f;
            double u1 = 0.0;
            double u2 = 16.0;
            double v1 = 0.0;
            double v2 = 16.0;
            TextureAtlasSprite sprite = btn.icon == null ? Minecraft.func_71410_x().func_147117_R().func_110572_b(ModelLoader.White.LOCATION.toString()) : btn.icon;
            double btnx1 = btn.x1 + 1.0;
            double btnx2 = btn.x2 - 1.0;
            double btny1 = btn.y1 + 1.0;
            double btny2 = btn.y2 - 1.0;
            float red = f * ((float)(btn.color >> 16 & 0xFF) / 255.0f);
            float green = f * ((float)(btn.color >> 8 & 0xFF) / 255.0f);
            float blue = f * ((float)(btn.color & 0xFF) / 255.0f);
            buffer.func_181662_b(middle_x + btnx1, middle_y + btny1, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(0.0), (double)sprite.func_94207_b(0.0)).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + btnx1, middle_y + btny2, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(0.0), (double)sprite.func_94207_b(16.0)).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + btnx2, middle_y + btny2, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(16.0), (double)sprite.func_94207_b(16.0)).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(middle_x + btnx2, middle_y + btny1, (double)this.field_73735_i).func_187315_a((double)sprite.func_94214_a(16.0), (double)sprite.func_94207_b(0.0)).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        for (MenuRegion mnuRgn : modes) {
            if (!mnuRgn.highlighted) continue;
            x = (mnuRgn.x1 + mnuRgn.x2) * 0.5;
            y = (mnuRgn.y1 + mnuRgn.y2) * 0.5;
            int fixed_x = (int)(x * 65.0);
            int fixed_y = (int)(y * 65.0);
            String text = mnuRgn.mode.getName().getLocal();
            if (x <= -0.2) {
                fixed_x -= this.field_146289_q.func_78256_a(text);
            } else if (-0.2 <= x && x <= 0.2) {
                fixed_x -= this.field_146289_q.func_78256_a(text) / 2;
            }
            this.field_146289_q.func_175063_a(text, (float)((int)middle_x + fixed_x), (float)((int)middle_y + fixed_y), -1);
        }
        for (MenuButton btn : btns) {
            if (!btn.highlighted) continue;
            String text = DeprecationHelper.translateToLocal(btn.name);
            if (btn.textSide == EnumFacing.WEST) {
                this.field_146289_q.func_175063_a(text, (float)((int)(middle_x + btn.x1 - 8.0) - this.field_146289_q.func_78256_a(text)), (float)((int)(middle_y + btn.y1 + 6.0)), -1);
                continue;
            }
            if (btn.textSide == EnumFacing.EAST) {
                this.field_146289_q.func_175063_a(text, (float)((int)(middle_x + btn.x2 + 8.0)), (float)((int)(middle_y + btn.y1 + 6.0)), -1);
                continue;
            }
            if (btn.textSide == EnumFacing.UP) {
                this.field_146289_q.func_175063_a(text, (float)((int)(middle_x + (btn.x1 + btn.x2) * 0.5 - (double)this.field_146289_q.func_78256_a(text) * 0.5)), (float)((int)(middle_y + btn.y1 - 14.0)), -1);
                continue;
            }
            if (btn.textSide != EnumFacing.DOWN) continue;
            this.field_146289_q.func_175063_a(text, (float)((int)(middle_x + (btn.x1 + btn.x2) * 0.5 - (double)this.field_146289_q.func_78256_a(text) * 0.5)), (float)((int)(middle_y + btn.y1 + 24.0)), -1);
        }
        GlStateManager.func_179121_F();
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && ChiselsAndBits.getConfig().enableVivecraftCompatibility) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    static class MenuRegion {
        public final IToolMode mode;
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;

        public MenuRegion(IToolMode mode) {
            this.mode = mode;
        }
    }

    private static class MenuButton {
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;
        public final ButtonAction action;
        public TextureAtlasSprite icon;
        public int color;
        public String name;
        public EnumFacing textSide;

        public MenuButton(String name, ButtonAction action, double x, double y, TextureAtlasSprite ico, EnumFacing textSide) {
            this.name = name;
            this.action = action;
            this.x1 = x;
            this.x2 = x + 18.0;
            this.y1 = y;
            this.y2 = y + 18.0;
            this.icon = ico;
            this.color = 0xFFFFFF;
            this.textSide = textSide;
        }

        public MenuButton(String name, ButtonAction action, double x, double y, int col, EnumFacing textSide) {
            this.name = name;
            this.action = action;
            this.x1 = x;
            this.x2 = x + 18.0;
            this.y1 = y;
            this.y2 = y + 18.0;
            this.color = col;
            this.textSide = textSide;
        }
    }
}

