/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.compat.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.event.MeatFeederTickHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MeatFeederBauble
implements IBauble,
ICapabilitySerializable<NBTTagCompound> {
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.HEAD;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            MeatFeederTickHandler.meatTick(itemstack, (EntityPlayer)player);
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public static class Event {
        @SubscribeEvent
        public void onAttachCapability(AttachCapabilitiesEvent<ItemStack> event) {
            if (((ItemStack)event.getObject()).func_77973_b().equals((Object)ItemRegistry.meatFeederItem)) {
                event.addCapability(new ResourceLocation("industrialforegoing", "meat_feeder"), (ICapabilityProvider)new MeatFeederBauble());
            }
        }
    }
}

