/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.DistanceRayTraceResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RayTraceUtils {
    public static RayTraceResult rayTraceBoxesClosest(Vec3d start, Vec3d end, BlockPos pos, List<Cuboid> boxes) {
        ArrayList<DistanceRayTraceResult> results = new ArrayList<DistanceRayTraceResult>();
        for (Cuboid box : boxes) {
            DistanceRayTraceResult hit = RayTraceUtils.rayTraceBox(pos, start, end, box);
            if (hit == null) continue;
            results.add(hit);
        }
        DistanceRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (DistanceRayTraceResult hit : results) {
            if (!(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static DistanceRayTraceResult rayTraceBox(BlockPos pos, Vec3d start, Vec3d end, Cuboid box) {
        Vec3d startRay = start.func_178788_d(new Vec3d((Vec3i)pos));
        Vec3d endRay = end.func_178788_d(new Vec3d((Vec3i)pos));
        RayTraceResult bbResult = box.aabb().func_72327_a(startRay, endRay);
        if (bbResult != null) {
            Vec3d hitVec = bbResult.field_72307_f.func_178787_e(new Vec3d((Vec3i)pos));
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = start.func_72436_e(hitVec);
            return new DistanceRayTraceResult(hitVec, pos, sideHit, box, dist);
        }
        return null;
    }

    public static RayTraceResult rayTrace(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player, double distance, List<Cuboid> boundingBoxes) {
        Vec3d vec3d = player.func_174824_e(0.0f);
        Vec3d vec3d1 = player.func_70676_i(0.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        return RayTraceUtils.rayTraceBoxesClosest(vec3d, vec3d2, pos, boundingBoxes);
    }

    public static RayTraceResult rayTraceSimple(World world, EntityLivingBase living, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = living.func_174824_e(partialTicks);
        Vec3d vec3d1 = living.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return world.func_147447_a(vec3d, vec3d2, false, false, true);
    }
}

