/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;

public class LatexProcessingUnitTile
extends CustomElectricMachine {
    private IFluidTank waterTank;
    private IFluidTank latexTank;
    private ItemStackHandler itemOut;

    public LatexProcessingUnitTile() {
        super(LatexProcessingUnitTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.waterTank = this.addFluidTank(FluidRegistry.WATER, 8000, EnumDyeColor.BLUE, "Water tank", new BoundingRectangle(46, 25, 18, 54));
        this.latexTank = this.addFluidTank(FluidsRegistry.LATEX, 8000, EnumDyeColor.GRAY, "Latex tank", new BoundingRectangle(67, 25, 18, 54));
        this.itemOut = new ItemStackHandler(9);
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.itemOut, EnumDyeColor.ORANGE, "Output items", new BoundingRectangle(111, 25, 54, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                int i = 0;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        slots.add(new FilteredSlot(this.getItemHandlerForContainer(), i, box.getLeft() + 1 + x * 18, box.getTop() + 1 + y * 18));
                        ++i;
                    }
                }
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 3, 3, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, EnumDyeColor.ORANGE));
                return pieces;
            }
        });
        this.addInventoryToStorage(this.itemOut, "latex_processing_unit_out");
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.waterTank.getFluid() != null && this.latexTank.getFluid() != null && this.waterTank.drain((int)1000, (boolean)false).amount == 1000 && this.latexTank.drain((int)75, (boolean)false).amount == 75 && ItemHandlerHelper.insertItem((IItemHandler)this.itemOut, (ItemStack)new ItemStack((Item)ItemRegistry.tinyDryRubber, 1), (boolean)true).func_190926_b()) {
            this.waterTank.drain(1000, true);
            this.latexTank.drain(75, true);
            ItemHandlerHelper.insertItem((IItemHandler)this.itemOut, (ItemStack)new ItemStack((Item)ItemRegistry.tinyDryRubber, 1), (boolean)false);
            return 1.0f;
        }
        return 0.0f;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return super.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        FluidStack fluid;
        ItemStack stack = fluidItems.getStackInSlot(0);
        if (!stack.func_190926_b() && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null) {
            if (fluid.getFluid() == FluidRegistry.WATER) {
                ItemStackUtils.fillTankFromItem(fluidItems, this.waterTank);
            }
            if (fluid.getFluid() == FluidsRegistry.LATEX) {
                ItemStackUtils.fillTankFromItem(fluidItems, this.latexTank);
            }
        }
    }
}

