/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.ore;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.tile.CustomElectricMachine;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import org.jetbrains.annotations.NotNull;

public class OreFermenterTile
extends CustomElectricMachine {
    private IFluidTank input;
    private IFluidTank output;

    public OreFermenterTile() {
        super(OreFermenterTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = this.addSimpleFluidTank(1000, "input", EnumDyeColor.BLUE, 60, 25, FluidTankType.INPUT, fluidStack -> true, fluidStack -> false);
        this.output = this.addSimpleFluidTank(1000, "output", EnumDyeColor.ORANGE, 115, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
    }

    protected float performWork() {
        if (this.hasColdSource() && this.hasHotSource()) {
            for (OreFluidEntryFermenter recipe : OreFluidEntryFermenter.ORE_FLUID_FERMENTER) {
                boolean didWork = false;
                for (int operations = 20; operations > 0; --operations) {
                    if (!recipe.getInput().isFluidEqual(this.input.getFluid()) || this.input.drain(recipe.getInput().amount, false) == null || this.input.drain((int)recipe.getInput().amount, (boolean)false).amount != recipe.getInput().amount || this.output.fill(recipe.getOutput(), false) != recipe.getOutput().amount) continue;
                    this.input.drain(recipe.getInput().amount, true);
                    this.output.fill(recipe.getOutput().copy(), true);
                    didWork = true;
                }
                if (!didWork) continue;
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public boolean hasHotSource() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
        if (fluid != null && fluid.getTemperature(this.field_145850_b, this.field_174879_c.func_177977_b()) >= 1300) {
            return true;
        }
        return blockState.func_177230_c().equals(Blocks.field_189877_df) || blockState.func_177230_c().equals(Blocks.field_150480_ab);
    }

    public boolean hasColdSource() {
        for (EnumFacing facing : new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
            if (fluid != null && fluid.getTemperature(this.field_145850_b, this.field_174879_c.func_177972_a(facing)) <= 300) {
                return true;
            }
            if (!blockState.func_177230_c().equals(Blocks.field_150432_aD) && !blockState.func_177230_c().equals(Blocks.field_150433_aE) && !blockState.func_177230_c().equals(Blocks.field_150403_cj)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(84, 45, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(143, 30, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialforegoing", "textures/gui/machines.png"));
                container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 1, 119, 14, 14);
                if (!OreFermenterTile.this.hasHotSource()) {
                    container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png"));
                    container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 146, 210, 14, 14);
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                container.drawTooltip(Collections.singletonList((OreFermenterTile.this.hasHotSource() ? TextFormatting.GREEN : TextFormatting.RED) + new TextComponentTranslation(OreFermenterTile.this.hasHotSource() ? "text.industrialforegoing.tooltip.found_heat" : "text.industrialforegoing.tooltip.missing_heat", new Object[0]).func_150261_e()), mouseX - guiX, mouseY - guiY);
            }
        });
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(143, 56, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialforegoing", "textures/gui/machines.png"));
                container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 16, 119, 14, 14);
                if (!OreFermenterTile.this.hasColdSource()) {
                    container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png"));
                    container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 146, 210, 14, 14);
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                container.drawTooltip(Collections.singletonList((OreFermenterTile.this.hasColdSource() ? TextFormatting.GREEN : TextFormatting.RED) + new TextComponentTranslation(OreFermenterTile.this.hasColdSource() ? "text.industrialforegoing.tooltip.found_cold" : "text.industrialforegoing.tooltip.missing_cold", new Object[0]).func_150261_e()), mouseX - guiX, mouseY - guiY);
            }
        });
        return pieces;
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }
}

