/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.ArrowInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrosterTile
extends CustomElectricMachine {
    private IFluidTank tank;
    private FrosterResult result = FrosterResult.NONE;
    private ItemStackHandler outItems;

    public FrosterTile() {
        super(FrosterTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addSimpleFluidTank(8000, "water", EnumDyeColor.BLUE, 48, 25, FluidTankType.INPUT, stack -> stack.getFluid().equals(FluidRegistry.WATER), stack -> false);
        this.outItems = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                FrosterTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output Items", 111, 25, 3, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
        this.registerSyncStringPart("result", nbtTagString -> {
            this.result = FrosterResult.valueOf(nbtTagString.func_150285_a_());
        }, () -> new NBTTagString(this.result.name()), SyncProviderLevel.GUI);
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(88, 43, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (FrosterTile.this.result == FrosterResult.NONE) {
                    container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png"));
                    container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 146, 210, 14, 14);
                } else {
                    RenderHelper.func_74520_c();
                    container.field_146297_k.func_175599_af().func_175042_a(FrosterTile.this.result.getResult(), guiX + this.getLeft() + 1, guiY + this.getTop() + 1);
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                if (FrosterTile.this.result == FrosterResult.NONE) {
                    container.drawTooltip(Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.none", new Object[0]).func_150261_e()), mouseX - guiX, mouseY - guiY);
                } else {
                    List tooltip = container.func_191927_a(FrosterTile.this.result.getResult());
                    tooltip.add(1, TextFormatting.GRAY + "" + FrosterTile.this.result.fluid + "mb");
                    container.drawTooltip(tooltip, mouseX - guiX, mouseY - guiY);
                }
            }
        });
        pieces.add((IGuiContainerPiece)new ArrowInfoPiece(90, 26, 17, 72, "text.industrialforegoing.button.decrease"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FrosterTile.this.sendToServer(FrosterTile.this.setupSpecialNBTMessage("PREV_OUTPUT"));
                }
            }
        });
        pieces.add((IGuiContainerPiece)new ArrowInfoPiece(90, 65, 33, 72, "text.industrialforegoing.button.increase"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FrosterTile.this.sendToServer(FrosterTile.this.setupSpecialNBTMessage("NEXT_OUTPUT"));
                }
            }
        });
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        if (messageType == null) {
            return super.processClientMessage(messageType, compound);
        }
        if (messageType.equals("NEXT_OUTPUT")) {
            this.result = FrosterResult.values()[(Arrays.asList(FrosterResult.values()).indexOf((Object)this.result) + 1) % FrosterResult.values().length];
            this.partialSync("result", true);
        }
        if (messageType.equals("PREV_OUTPUT")) {
            int pointer = Arrays.asList(FrosterResult.values()).indexOf((Object)this.result) - 1;
            if (pointer < 0) {
                pointer = FrosterResult.values().length - 1;
            }
            this.result = FrosterResult.values()[pointer];
            this.partialSync("result", true);
        }
        return super.processClientMessage(messageType, compound);
    }

    protected float performWork() {
        if (this.result != FrosterResult.NONE && this.tank.getFluidAmount() >= this.result.getFluid() && ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)this.result.getResult(), (boolean)true).func_190926_b()) {
            this.tank.drain(this.result.getFluid(), true);
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)this.result.getResult().func_77946_l(), (boolean)false);
            return 1.0f;
        }
        return 0.0f;
    }

    public static enum FrosterResult {
        NONE(ItemStack.field_190927_a, 1),
        SNOW(new ItemStack(Items.field_151126_ay), 250),
        ICE(new ItemStack(Blocks.field_150432_aD), 1000),
        PACKED(new ItemStack(Blocks.field_150403_cj), 2500);

        private final ItemStack result;
        private final int fluid;

        private FrosterResult(ItemStack result, int fluid) {
            this.result = result;
            this.fluid = fluid;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public int getFluid() {
            return this.fluid;
        }
    }
}

