/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.proxy.client.infopiece.ArrowInfoPiece;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDictionaryConverterTile
extends CustomSidedTileEntity {
    public static List<String> INPUT_LIST = FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().map(FluidDictionaryEntry::getFluidOrigin).distinct().collect(Collectors.toList());
    private IFluidTank input;
    private IFluidTank output;
    private int inputPointer = 0;
    private int outputPointer = 0;

    public FluidDictionaryConverterTile() {
        super(FluidDictionaryConverterTile.class.getName().hashCode());
    }

    public static List<String> getOutputListFromFluid(String input) {
        return FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().filter(entry -> entry.getFluidOrigin().equals(input)).map(FluidDictionaryEntry::getFluidResult).collect(Collectors.toList());
    }

    public static FluidDictionaryEntry getRecipe(String input, String output) {
        return FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().filter(entry -> entry.getFluidOrigin().equals(input) && entry.getFluidResult().equals(output)).findFirst().orElse(null);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = this.addSimpleFluidTank(8000, "input", EnumDyeColor.BLUE, 60, 25, FluidTankType.INPUT, fluidStack -> true, fluidStack -> false);
        this.output = this.addSimpleFluidTank(8000, "output", EnumDyeColor.ORANGE, 115, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
        this.registerSyncIntPart("input", nbtTagInt -> {
            this.inputPointer = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.inputPointer), SyncProviderLevel.GUI);
        this.registerSyncIntPart("output", nbtTagInt -> {
            this.outputPointer = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.outputPointer), SyncProviderLevel.GUI);
    }

    protected void innerUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WorkUtils.isDisabled(this.field_145854_h)) {
            return;
        }
        if (this.inputPointer > INPUT_LIST.size() || this.inputPointer < 0) {
            this.inputPointer = 0;
            this.partialSync("input", true);
        }
        if (this.inputPointer == 0 && this.outputPointer != 0) {
            this.outputPointer = 0;
            this.partialSync("output", true);
        }
        if (this.inputPointer == 0 || this.outputPointer == 0) {
            return;
        }
        if (this.input.getFluidAmount() >= 100) {
            if (!this.input.getFluid().getFluid().getName().equals(INPUT_LIST.get(this.inputPointer - 1))) {
                return;
            }
            FluidDictionaryEntry entry = FluidDictionaryConverterTile.getRecipe(INPUT_LIST.get(this.inputPointer - 1), FluidDictionaryConverterTile.getOutputListFromFluid(INPUT_LIST.get(this.inputPointer - 1)).get(this.outputPointer - 1));
            if (entry != null) {
                int fillAmount = (int)Math.floor(100.0 * entry.getRatio());
                if (this.output.fill(FluidRegistry.getFluidStack((String)entry.getFluidResult(), (int)fillAmount), false) == fillAmount) {
                    this.input.drain(100, true);
                    this.output.fill(FluidRegistry.getFluidStack((String)entry.getFluidResult(), (int)fillAmount), true);
                }
            }
        }
    }

    protected boolean supportsAddons() {
        return false;
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        this.inputPointer = compound.func_74762_e("PointerInput");
        this.outputPointer = compound.func_74762_e("PointerOutput");
        super.func_145839_a(compound);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("PointerInput", this.inputPointer);
        compound.func_74768_a("PointerOutput", this.outputPointer);
        return compound;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        if (messageType == null) {
            return super.processClientMessage(messageType, compound);
        }
        if (messageType.equals("NEXT_INPUT")) {
            this.inputPointer = (this.inputPointer + 1) % (INPUT_LIST.size() + 1);
            this.outputPointer = 0;
            this.partialSync("input", true);
            this.partialSync("output", true);
        }
        if (messageType.equals("PREV_INPUT")) {
            --this.inputPointer;
            if (this.inputPointer < 0) {
                this.inputPointer = INPUT_LIST.size();
            }
            this.outputPointer = 0;
            this.partialSync("input", true);
            this.partialSync("output", true);
        }
        if (messageType.equals("NEXT_OUTPUT") && this.inputPointer != 0) {
            this.outputPointer = (this.outputPointer + 1) % (FluidDictionaryConverterTile.getOutputListFromFluid(INPUT_LIST.get(this.inputPointer - 1)).size() + 1);
            this.partialSync("output", true);
        }
        if (messageType.equals("PREV_OUTPUT") && this.inputPointer != 0) {
            --this.outputPointer;
            if (this.outputPointer < 0) {
                this.outputPointer = FluidDictionaryConverterTile.getOutputListFromFluid(INPUT_LIST.get(this.inputPointer - 1)).size();
            }
            this.partialSync("output", true);
        }
        return super.processClientMessage(messageType, compound);
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(84, 45, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add(new BasicRenderedGuiPiece(40, 43, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                ItemStack stack;
                String fluidName;
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (FluidDictionaryConverterTile.this.inputPointer == 0) {
                    container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png"));
                    container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 146, 210, 14, 14);
                } else if (FluidDictionaryConverterTile.this.inputPointer - 1 < INPUT_LIST.size() && FluidRegistry.isFluidRegistered((String)(fluidName = INPUT_LIST.get(FluidDictionaryConverterTile.this.inputPointer - 1))) && !(stack = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1000))).func_190926_b()) {
                    container.field_146297_k.func_175599_af().func_175042_a(stack, guiX + this.getLeft() + 1, guiY + this.getTop() + 1);
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                ItemStack stack;
                String fluidName;
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                if (FluidDictionaryConverterTile.this.inputPointer <= 0) {
                    container.drawTooltip(Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.none", new Object[0]).func_150261_e()), mouseX - guiX, mouseY - guiY);
                } else if (FluidDictionaryConverterTile.this.inputPointer - 1 < INPUT_LIST.size() && FluidRegistry.isFluidRegistered((String)(fluidName = INPUT_LIST.get(FluidDictionaryConverterTile.this.inputPointer - 1))) && !(stack = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1000))).func_190926_b()) {
                    container.drawTooltip(container.func_191927_a(stack), mouseX - guiX, mouseY - guiY);
                }
            }
        });
        pieces.add(new BasicRenderedGuiPiece(136, 43, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (FluidDictionaryConverterTile.this.outputPointer <= 0) {
                    container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png"));
                    container.drawTexturedRect(this.getLeft() + 2, this.getTop() + 2, 146, 210, 14, 14);
                } else if (FluidDictionaryConverterTile.this.inputPointer > 0 && FluidDictionaryConverterTile.this.inputPointer - 1 < INPUT_LIST.size()) {
                    ItemStack stack;
                    String fluidName;
                    List<String> names = FluidDictionaryConverterTile.getOutputListFromFluid(INPUT_LIST.get(FluidDictionaryConverterTile.this.inputPointer - 1));
                    if (FluidDictionaryConverterTile.this.outputPointer - 1 < names.size() && FluidRegistry.isFluidRegistered((String)(fluidName = names.get(FluidDictionaryConverterTile.this.outputPointer - 1))) && !(stack = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1000))).func_190926_b()) {
                        container.field_146297_k.func_175599_af().func_175042_a(stack, guiX + this.getLeft() + 1, guiY + this.getTop() + 1);
                    }
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
                if (!this.isInside(container, mouseX, mouseY)) {
                    return;
                }
                if (FluidDictionaryConverterTile.this.outputPointer == 0) {
                    container.drawTooltip(Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.none", new Object[0]).func_150261_e()), mouseX - guiX, mouseY - guiY);
                } else {
                    ItemStack stack;
                    String fluidName;
                    List<String> names = FluidDictionaryConverterTile.getOutputListFromFluid(INPUT_LIST.get(FluidDictionaryConverterTile.this.inputPointer - 1));
                    if (FluidDictionaryConverterTile.this.outputPointer - 1 < names.size() && FluidRegistry.isFluidRegistered((String)(fluidName = names.get(FluidDictionaryConverterTile.this.outputPointer - 1))) && !(stack = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1000))).func_190926_b()) {
                        container.drawTooltip(container.func_191927_a(stack), mouseX - guiX, mouseY - guiY);
                    }
                }
            }
        });
        pieces.add(new ArrowInfoPiece(42, 26, 17, 72, "text.industrialforegoing.button.decrease_fluid"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FluidDictionaryConverterTile.this.sendToServer(FluidDictionaryConverterTile.this.setupSpecialNBTMessage("PREV_INPUT"));
                }
            }
        });
        pieces.add(new ArrowInfoPiece(42, 65, 33, 72, "text.industrialforegoing.button.increase_fluid"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FluidDictionaryConverterTile.this.sendToServer(FluidDictionaryConverterTile.this.setupSpecialNBTMessage("NEXT_INPUT"));
                }
            }
        });
        pieces.add(new ArrowInfoPiece(138, 26, 17, 72, "text.industrialforegoing.button.decrease_fluid"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FluidDictionaryConverterTile.this.sendToServer(FluidDictionaryConverterTile.this.setupSpecialNBTMessage("PREV_OUTPUT"));
                }
            }
        });
        pieces.add(new ArrowInfoPiece(138, 65, 33, 72, "text.industrialforegoing.button.increase_fluid"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    FluidDictionaryConverterTile.this.sendToServer(FluidDictionaryConverterTile.this.setupSpecialNBTMessage("NEXT_OUTPUT"));
                }
            }
        });
        return pieces;
    }
}

