/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class FruitTreeGen
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final IBlockState metaWood;
    private final IBlockState metaLeaves;
    private final IBlockState fruitType;

    public FruitTreeGen(int minTreeHeight, IBlockState metaWood, IBlockState metaLeaves, boolean doVinesGrow, IBlockState fruitType) {
        super(true);
        this.minTreeHeight = minTreeHeight;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.vinesGrow = doVinesGrow;
        this.fruitType = fruitType;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        boolean canGenerate = true;
        int treeTopPos = blockPos.func_177956_o() + treeHeight;
        if (blockPos.func_177956_o() >= 1 && treeTopPos <= 255) {
            for (int iPosY = blockPos.func_177956_o(); iPosY <= treeTopPos + 1; ++iPosY) {
                int k = 1;
                if (iPosY == blockPos.func_177956_o()) {
                    k = 0;
                }
                if (iPosY >= treeTopPos - 1) {
                    k = 2;
                }
                int halflength = blockPos.func_177958_n() + k;
                for (int iPosX = blockPos.func_177958_n() - k; iPosX <= halflength + k && canGenerate; ++iPosX) {
                    int halfLength = blockPos.func_177952_p() + k;
                    for (int iPosZ = blockPos.func_177952_p() - k; iPosZ <= halfLength + k && canGenerate; ++iPosZ) {
                        if (iPosY >= 0 && iPosY < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableBlockPos.func_181079_c(iPosX, iPosY, iPosZ))) continue;
                            canGenerate = false;
                            continue;
                        }
                        canGenerate = false;
                    }
                }
            }
            if (!canGenerate) {
                return false;
            }
            BlockPos down = blockPos.func_177977_b();
            IBlockState blockState = worldIn.func_180495_p(down);
            Block block = blockState.func_177230_c();
            boolean isSoil = block.canSustainPlant(blockState, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && treeTopPos + 1 < 256) {
                int i;
                int xEnd;
                block.onPlantGrow(blockState, worldIn, down, blockPos);
                for (int iPosY = treeTopPos - 3; iPosY <= treeTopPos; ++iPosY) {
                    int distanceToTop = iPosY - treeTopPos;
                    int margin = 1 - distanceToTop / 2;
                    xEnd = blockPos.func_177958_n() + margin;
                    for (int xStart = blockPos.func_177958_n() - margin; xStart <= xEnd; ++xStart) {
                        int currentMarginX = Math.abs(xStart - blockPos.func_177958_n());
                        int zEnd = blockPos.func_177952_p() + margin;
                        for (int zStart = blockPos.func_177952_p() - margin; zStart <= zEnd; ++zStart) {
                            int currentMarginZ = Math.abs(zStart - blockPos.func_177952_p());
                            if (currentMarginX == margin && currentMarginZ == margin && (rand.nextInt(2) == 0 || distanceToTop == 0)) continue;
                            BlockPos leavesBlockPos = new BlockPos(xStart, iPosY, zStart);
                            IBlockState leavesBlockState = worldIn.func_180495_p(leavesBlockPos);
                            Block leavesBlock = worldIn.func_180495_p(leavesBlockPos).func_177230_c();
                            if (!leavesBlock.isAir(leavesBlockState, (IBlockAccess)worldIn, leavesBlockPos) && !leavesBlock.isLeaves(leavesBlockState, (IBlockAccess)worldIn, leavesBlockPos) && leavesBlock.func_149688_o(leavesBlockState) != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, leavesBlockPos, this.metaLeaves);
                            BlockPos fruitBlockPos = new BlockPos(xStart, iPosY - 1, zStart);
                            BlockPos blockBelowFruitPos = new BlockPos(xStart, iPosY - 2, zStart);
                            if (!worldIn.func_175623_d(fruitBlockPos) || !worldIn.func_175623_d(blockBelowFruitPos) || iPosY <= 2 || rand.nextInt(4) != 0) continue;
                            this.func_175903_a(worldIn, fruitBlockPos, this.fruitType);
                        }
                    }
                }
                for (i = 0; i < treeHeight; ++i) {
                    BlockPos upN = blockPos.func_177981_b(i);
                    IBlockState blockStateUp = worldIn.func_180495_p(upN);
                    Block blockUp = blockStateUp.func_177230_c();
                    if (!blockUp.isAir(blockStateUp, (IBlockAccess)worldIn, upN) && !blockUp.isLeaves(blockStateUp, (IBlockAccess)worldIn, upN) && blockUp != this.fruitType.func_177230_c() && blockUp.func_149688_o(blockStateUp) != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, blockPos.func_177981_b(i), this.metaWood);
                    if (!this.vinesGrow || i <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(blockPos.func_177982_a(-1, i, 0))) {
                        this.setBlockVine(worldIn, blockPos.func_177982_a(-1, i, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(blockPos.func_177982_a(1, i, 0))) {
                        this.setBlockVine(worldIn, blockPos.func_177982_a(1, i, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(blockPos.func_177982_a(0, i, -1))) {
                        this.setBlockVine(worldIn, blockPos.func_177982_a(0, i, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(blockPos.func_177982_a(0, i, 1))) continue;
                    this.setBlockVine(worldIn, blockPos.func_177982_a(0, i, 1), BlockVine.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (int yBottom = treeTopPos - 3; yBottom <= treeTopPos; ++yBottom) {
                        int distanceToTop = yBottom - treeTopPos;
                        int k = 2 - distanceToTop / 2;
                        xEnd = blockPos.func_177958_n() + k;
                        for (int xStart = blockPos.func_177958_n() - k; xStart <= xEnd; ++xStart) {
                            int zEnd = blockPos.func_177952_p() + k;
                            for (int zStart = blockPos.func_177952_p() - k; zStart <= zEnd; ++zStart) {
                                mutableBlockPos.func_181079_c(xStart, yBottom, zStart);
                                if (!worldIn.func_180495_p((BlockPos)mutableBlockPos).func_177230_c().isLeaves(worldIn.func_180495_p((BlockPos)mutableBlockPos), (IBlockAccess)worldIn, (BlockPos)mutableBlockPos)) continue;
                                BlockPos posWest = mutableBlockPos.func_177976_e();
                                BlockPos posEast = mutableBlockPos.func_177974_f();
                                BlockPos posNorth = mutableBlockPos.func_177978_c();
                                BlockPos posSouth = mutableBlockPos.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(posWest).func_177230_c().isAir(worldIn.func_180495_p(posWest), (IBlockAccess)worldIn, posWest)) {
                                    this.setVines(worldIn, posWest, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(posEast).func_177230_c().isAir(worldIn.func_180495_p(posEast), (IBlockAccess)worldIn, posEast)) {
                                    this.setVines(worldIn, posEast, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(posNorth).func_177230_c().isAir(worldIn.func_180495_p(posNorth), (IBlockAccess)worldIn, posNorth)) {
                                    this.setVines(worldIn, posNorth, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_180495_p(posSouth).func_177230_c().isAir(worldIn.func_180495_p(posSouth), (IBlockAccess)worldIn, posSouth)) continue;
                                this.setVines(worldIn, posSouth, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && treeHeight > 5) {
                        for (i = 0; i < 2; ++i) {
                            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - i) != 0) continue;
                                EnumFacing oppositeFacing = enumfacing.func_176734_d();
                                this.setBlockCocoa(worldIn, rand.nextInt(3), blockPos.func_177982_a(oppositeFacing.func_82601_c(), treeHeight - 5 + i, oppositeFacing.func_82599_e()), enumfacing);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void setBlockCocoa(World world, int age, BlockPos blockPos, EnumFacing facing) {
        this.func_175903_a(world, blockPos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)facing));
    }

    private void setBlockVine(World world, BlockPos blockPos, PropertyBool propertyBool) {
        this.func_175903_a(world, blockPos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)propertyBool, (Comparable)Boolean.valueOf(true)));
    }

    private void setVines(World world, BlockPos blockPos, PropertyBool propertyBool) {
        this.setBlockVine(world, blockPos, propertyBool);
        blockPos = blockPos.func_177977_b();
        for (int i = 4; world.func_180495_p(blockPos).func_177230_c().isAir(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos) && i > 0; --i) {
            this.setBlockVine(world, blockPos, propertyBool);
            blockPos = blockPos.func_177977_b();
        }
    }
}

