/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.wheelsupport;

import com.google.common.base.Function;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.intwheel.api.IInteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.IWheelActionProvider;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitBlock;
import mcjty.rftools.wheelsupport.FindBlockAction;
import mcjty.rftools.wheelsupport.RemoveBlockAction;
import mcjty.rftools.wheelsupport.ResizeScreenAction;
import mcjty.rftools.wheelsupport.ToggleScreenTransparentAction;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;

public class WheelCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"intwheel", (String)"getTheWheel", (String)"mcjty.rftools.wheelsupport.WheelCompatibility$GetTheWheel");
    }

    public static class GetTheWheel
    implements Function<IInteractionWheel, Void> {
        public static IInteractionWheel wheel;

        @Nullable
        public Void apply(IInteractionWheel theWheel) {
            wheel = theWheel;
            Logging.getLogger().log(Level.INFO, "Enabled support for The Interaction Wheel");
            wheel.registerProvider(new IWheelActionProvider(){

                public String getID() {
                    return "rftools.wheel";
                }

                public void updateWheelActions(@Nonnull Set<String> actions, @Nonnull EntityPlayer player, World world, @Nullable BlockPos pos) {
                    if (pos != null) {
                        Block block = world.func_180495_p(pos).func_177230_c();
                        actions.add("rftools.findblock");
                        if (block instanceof GenericBlock) {
                            actions.add("rftools.removeblock");
                        }
                        if (block instanceof ScreenBlock || block instanceof ScreenHitBlock) {
                            actions.add("rftools.resizescreen");
                            actions.add("rftools.toggletransp");
                        }
                    }
                }
            });
            wheel.getRegistry().register((IWheelAction)new RemoveBlockAction());
            wheel.getRegistry().register((IWheelAction)new ResizeScreenAction());
            wheel.getRegistry().register((IWheelAction)new ToggleScreenTransparentAction());
            wheel.getRegistry().register((IWheelAction)new FindBlockAction());
            return null;
        }
    }
}

