/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.creativeonly;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TabbedPanel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.rftools.items.creativeonly.DelightingInfoHelper;
import mcjty.rftools.items.creativeonly.PacketGetDelightingInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiDevelopersDelight
extends GuiScreen {
    protected int xSize = 410;
    protected int ySize = 210;
    private static BlockPos selected;
    private static List<String> blockClasses;
    private static List<String> teClasses;
    private static Map<String, DelightingInfoHelper.NBTDescription> nbtData;
    private static int server_metadata;
    private Window window;
    private WidgetList blockClassList;
    private WidgetList teClassList;
    private WidgetList nbtDataList;
    private TabbedPanel tabbedPanel;
    private ChoiceLabel clientServerMode;
    private TextField metaData;
    private List<ToggleButton> pageButtons = new ArrayList<ToggleButton>();
    private boolean listsDirty = true;

    public boolean func_73868_f() {
        return false;
    }

    public static void setSelected(BlockPos pos) {
        selected = pos;
    }

    public static void setServerBlockClasses(List<String> blockClasses) {
        GuiDevelopersDelight.blockClasses = new ArrayList<String>(blockClasses);
    }

    public static void setServerTEClasses(List<String> teClasses) {
        GuiDevelopersDelight.teClasses = new ArrayList<String>(teClasses);
    }

    public static void setServerNBTData(Map<String, DelightingInfoHelper.NBTDescription> nbtData) {
        GuiDevelopersDelight.nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>(nbtData);
    }

    public static void setMetadata(int metadata) {
        server_metadata = metadata;
    }

    private void requestDelightingInfoFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDelightingInfo(selected));
    }

    private void requestDelightingInfoFromClient() {
        blockClasses = new ArrayList<String>();
        teClasses = new ArrayList<String>();
        nbtData = new HashMap<String, DelightingInfoHelper.NBTDescription>();
        server_metadata = DelightingInfoHelper.fillDelightingData(selected.func_177958_n(), selected.func_177956_o(), selected.func_177952_p(), (World)this.field_146297_k.field_71441_e, blockClasses, teClasses, nbtData);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        this.tabbedPanel = new TabbedPanel(this.field_146297_k, (Gui)this);
        Panel tab1 = this.createBlockClassesPage();
        Panel tab2 = this.createTeClassesPage();
        Panel tab3 = this.createNbtDataPage();
        this.tabbedPanel.addPage("Block", (Widget)tab1).addPage("TE", (Widget)tab2).addPage("NBT", (Widget)tab3);
        ToggleButton tab1Button = this.createToggleButton("Block");
        ToggleButton tab2Button = this.createToggleButton("TE");
        ToggleButton tab3Button = this.createToggleButton("NBT");
        this.clientServerMode = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(60)).addChoices(new String[]{"Server", "Client"}).setChoice("Server").addChoiceEvent((parent, newChoice) -> this.requestNewLists()).setDesiredHeight(16)).setTooltips(new String[]{"Switch between client", "and server information"});
        this.metaData = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(14)).setTooltips(new String[]{"Metadata for this block"});
        Panel buttonPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setDesiredWidth(62)).addChildren(new Widget[]{tab1Button, tab2Button, tab3Button, new Label(this.field_146297_k, (Gui)this).setDynamic(true), this.clientServerMode, this.metaData, new Label(this.field_146297_k, (Gui)this).setDynamic(true)});
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new HorizontalLayout()).addChildren(new Widget[]{buttonPanel, this.tabbedPanel});
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.requestNewLists();
    }

    private void requestNewLists() {
        this.listsDirty = true;
        teClasses = null;
        blockClasses = null;
        nbtData = null;
        if ("Server".equals(this.clientServerMode.getCurrentChoice())) {
            this.requestDelightingInfoFromServer();
        } else {
            this.requestDelightingInfoFromClient();
        }
    }

    private ToggleButton createToggleButton(String pagename) {
        ToggleButton toggleButton = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText(pagename)).addButtonEvent(parent -> {
            ToggleButton tb = (ToggleButton)parent;
            if (tb.isPressed()) {
                this.activatePage(tb, pagename);
            }
        }).setDynamic(true)).setDesiredHeight(18);
        this.pageButtons.add(toggleButton);
        return toggleButton;
    }

    private void activatePage(ToggleButton tb, String pagename) {
        for (ToggleButton toggleButton : this.pageButtons) {
            if (tb == toggleButton) continue;
            toggleButton.setPressed(false);
        }
        this.tabbedPanel.setCurrent(pagename);
    }

    private Panel createBlockClassesPage() {
        this.blockClassList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("blocks");
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setVertical().setScrollableName("blocks");
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.blockClassList)).addChild((Widget)listSlider);
    }

    private Panel createTeClassesPage() {
        this.teClassList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("classes");
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setVertical().setScrollableName("classes");
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.teClassList)).addChild((Widget)listSlider);
    }

    private Panel createNbtDataPage() {
        this.nbtDataList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("nbtdata");
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setVertical().setScrollableName("nbtdata");
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.nbtDataList)).addChild((Widget)listSlider);
    }

    private void populateLists() {
        if (!this.listsDirty) {
            return;
        }
        if (teClasses == null || blockClasses == null || nbtData == null) {
            return;
        }
        this.listsDirty = false;
        this.blockClassList.removeChildren();
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(selected);
        Block block = state.func_177230_c();
        this.blockClassList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText("Loc Name: " + block.func_149732_F())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        this.blockClassList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText("Unloc Name: " + block.func_149739_a())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        this.blockClassList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText("Block Name: " + Block.field_149771_c.func_177774_c((Object)block))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        for (String string : blockClasses) {
            this.blockClassList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText("Class: " + string)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
        this.teClassList.removeChildren();
        for (String string : teClasses) {
            this.teClassList.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText(string)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
        this.nbtDataList.removeChildren();
        for (Map.Entry entry : nbtData.entrySet()) {
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText((String)entry.getKey())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(70));
            DelightingInfoHelper.NBTDescription value = (DelightingInfoHelper.NBTDescription)entry.getValue();
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText(value.getType())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(50));
            panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText(value.getValue())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
            this.nbtDataList.addChild((Widget)panel);
        }
        this.metaData.setText(String.valueOf(server_metadata));
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.window.mouseMovedOrUp(mouseX, mouseY, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }

    static {
        blockClasses = null;
        teClasses = null;
        nbtData = null;
        server_metadata = 0;
    }
}

