/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.GuiMatterReceiver;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MatterReceiverTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static final String CMD_ADDPLAYER = "receiver.addPlayer";
    public static final String CMD_DELPLAYER = "receiver.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private String name = null;
    private boolean privateAccess = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    public static final Key<Boolean> VALUE_PRIVATE = new Key("private", Type.BOOLEAN);
    private BlockPos cachedPos;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getName, this::setName), new DefaultValue(VALUE_PRIVATE, this::isPrivateAccess, this::setPrivateAccess)};
    }

    public MatterReceiverTileEntity() {
        super((long)TeleportConfiguration.RECEIVER_MAXENERGY, (long)TeleportConfiguration.RECEIVER_RECEIVEPERTICK);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension());
            this.id = destinations.getNewId(gc);
            destinations.save();
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.markDirtyClient();
    }

    public void setName(String name) {
        this.name = name;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
        TeleportDestination destination = destinations.getDestination(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension());
        if (destination != null) {
            destination.setName(name);
            destinations.save();
        }
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.func_174877_v().equals((Object)this.cachedPos)) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            destinations.removeDestination(this.cachedPos, this.func_145831_w().field_73011_w.getDimension());
            this.cachedPos = this.func_174877_v();
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension());
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save();
            this.func_70296_d();
        }
    }

    public void updateDestination() {
        GlobalCoordinate gc;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
        TeleportDestination destination = destinations.getDestination((gc = new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension())).getCoordinate(), gc.getDimension());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.func_70296_d();
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.save();
        }
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public int checkStatus() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a());
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v().func_177984_a())) {
            return 1;
        }
        block = this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(2)).func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.func_145831_w(), this.func_174877_v().func_177981_b(2))) {
            return 1;
        }
        if (this.getStoredPower() < (long)TeleportConfiguration.rfPerTeleportReceiver) {
            return 16;
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cachedPos = new BlockPos(tagCompound.func_74762_e("cachedX"), tagCompound.func_74762_e("cachedY"), tagCompound.func_74762_e("cachedZ"));
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("tpName");
        this.privateAccess = tagCompound.func_74767_n("private");
        this.allowedPlayers.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.allowedPlayers.add(player);
            }
        }
        this.id = tagCompound.func_74764_b("destinationId") ? tagCompound.func_74762_e("destinationId") : -1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.cachedPos != null) {
            tagCompound.func_74768_a("cachedX", this.cachedPos.func_177958_n());
            tagCompound.func_74768_a("cachedY", this.cachedPos.func_177956_o());
            tagCompound.func_74768_a("cachedZ", this.cachedPos.func_177952_p());
        }
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("tpName", this.name);
        }
        tagCompound.func_74757_a("private", this.privateAccess);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.allowedPlayers) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
        tagCompound.func_74768_a("destinationId", this.id);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getAllowedPlayers());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterReceiver.storeAllowedPlayersForClient(Type.STRING.convert(list));
            return true;
        }
        return false;
    }
}

