/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.io.IOException;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.ProjectorOpcode;
import mcjty.rftools.blocks.shaper.ProjectorOperation;
import mcjty.rftools.blocks.shaper.ProjectorTileEntity;
import mcjty.rftools.blocks.shaper.ShapeGuiTools;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiProjector
extends GenericGuiContainer<ProjectorTileEntity>
implements IShapeParentGui {
    public static final int SIDEWIDTH = 80;
    public static final int PROJECTOR_WIDTH = 256;
    public static final int PROJECTOR_HEIGHT = 238;
    private static final ResourceLocation sideBackground = new ResourceLocation("rftools", "textures/gui/sidegui_projector.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/projector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private ToggleButton showAxis;
    private ToggleButton showOuter;
    private ToggleButton showScan;
    private ScrollableLabel angleLabel;
    private ScrollableLabel offsetLabel;
    private ScrollableLabel scaleLabel;
    private Slider angleSlider;
    private Slider offsetSlider;
    private Slider scaleSlider;
    private ToggleButton autoRotate;
    private ToggleButton scanline;
    private ToggleButton sound;
    private ToggleButton grayScale;
    private ChoiceLabel[] rsLabelOn = new ChoiceLabel[4];
    private ChoiceLabel[] rsLabelOff = new ChoiceLabel[4];
    private TextField[] valOn = new TextField[4];
    private TextField[] valOff = new TextField[4];
    private Window sideWindow;
    private ShapeRenderer shapeRenderer = null;

    public GuiProjector(ProjectorTileEntity te, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, RFTools.GUI_MANUAL_SHAPE, "projector");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(((ProjectorTileEntity)this.tileEntity).getShapeID());
        }
        return this.shapeRenderer;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.field_147009_r + 100);
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        long maxEnergyStored = ((ProjectorTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint(6, 184, 75, 10)).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        Label angleI = (Label)new Label(this.field_146297_k, (Gui)this).setText("Angle");
        angleI.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        angleI.setLayoutHint(16, 30, 32, 15);
        this.angleLabel = (ScrollableLabel)((ScrollableLabel)((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setName("angle")).setRealMinimum(0).setRealMaximum(360).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setLayoutHint(44, 30, 24, 15);
        this.angleLabel.setRealValue(((ProjectorTileEntity)this.tileEntity).getAngleInt());
        Button angleM = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("anglemin")).setText("-")).setLayoutHint(5, 30, 10, 15);
        Button angleP = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("angleplus")).setText("+")).setLayoutHint(70, 30, 10, 15);
        this.angleSlider = (Slider)new Slider(this.field_146297_k, (Gui)this).setHorizontal().setScrollableName("angle").setLayoutHint(5, 46, 76, 15);
        toplevel.addChildren(new Widget[]{angleI, this.angleLabel, this.angleSlider, angleM, angleP});
        Label scaleI = (Label)new Label(this.field_146297_k, (Gui)this).setText("Scale");
        scaleI.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        scaleI.setLayoutHint(16, 62, 32, 15);
        this.scaleLabel = (ScrollableLabel)((ScrollableLabel)((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setName("scale")).setRealMinimum(0).setRealMaximum(100).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setLayoutHint(44, 62, 24, 15);
        this.scaleLabel.setRealValue(((ProjectorTileEntity)this.tileEntity).getScaleInt());
        Button scaleM = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("scalemin")).setText("-")).setLayoutHint(5, 62, 10, 15);
        Button scaleP = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("scaleplus")).setText("+")).setLayoutHint(70, 62, 10, 15);
        this.scaleSlider = (Slider)new Slider(this.field_146297_k, (Gui)this).setHorizontal().setScrollableName("scale").setLayoutHint(5, 78, 76, 15);
        toplevel.addChildren(new Widget[]{scaleI, this.scaleLabel, this.scaleSlider, scaleM, scaleP});
        Label offsetI = (Label)new Label(this.field_146297_k, (Gui)this).setText("Offset");
        offsetI.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        offsetI.setLayoutHint(16, 94, 32, 15);
        this.offsetLabel = (ScrollableLabel)((ScrollableLabel)((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setName("offset")).setRealMinimum(0).setRealMaximum(100).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setLayoutHint(44, 94, 24, 15);
        this.offsetLabel.setRealValue(((ProjectorTileEntity)this.tileEntity).getOffsetInt());
        Button offsetM = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("offsetmin")).setText("-")).setLayoutHint(5, 94, 10, 15);
        Button offsetP = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("offsetplus")).setText("+")).setLayoutHint(70, 94, 10, 15);
        this.offsetSlider = (Slider)new Slider(this.field_146297_k, (Gui)this).setHorizontal().setScrollableName("offset").setLayoutHint(5, 110, 76, 15);
        toplevel.addChildren(new Widget[]{offsetI, this.offsetLabel, this.offsetSlider, offsetM, offsetP});
        this.autoRotate = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("Auto")).setTooltips(new String[]{"Automatic client-side rotation"})).setLayoutHint(2, 128, 39, 16);
        this.autoRotate.setPressed(((ProjectorTileEntity)this.tileEntity).isAutoRotate());
        toplevel.addChild((Widget)this.autoRotate);
        this.scanline = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("SL")).setTooltips(new String[]{"Enable/disable visual scanlines when", "the scan is refreshed"})).setLayoutHint(42, 128, 39, 16);
        this.scanline.setPressed(((ProjectorTileEntity)this.tileEntity).isScanline());
        toplevel.addChild((Widget)this.scanline);
        this.sound = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("Snd")).setTooltips(new String[]{"Enable/disable sound during", "visual scan"})).setLayoutHint(2, 146, 39, 16);
        this.sound.setPressed(((ProjectorTileEntity)this.tileEntity).isSound());
        toplevel.addChild((Widget)this.sound);
        this.grayScale = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setCheckMarker(true).setText("Gray")).setTooltips(new String[]{"Enable/disable grayscale", "mode"})).setLayoutHint(42, 146, 39, 16);
        this.grayScale.setPressed(((ProjectorTileEntity)this.tileEntity).isGrayscale());
        toplevel.addChild((Widget)this.grayScale);
        this.angleLabel.addValueEvent((parent, newValue) -> this.update());
        this.scaleLabel.addValueEvent((parent, newValue) -> this.update());
        this.offsetLabel.addValueEvent((parent, newValue) -> this.update());
        this.autoRotate.addButtonEvent(parent -> this.update());
        this.scanline.addButtonEvent(parent -> this.update());
        this.sound.addButtonEvent(parent -> this.update());
        this.grayScale.addButtonEvent(parent -> this.update());
        this.showAxis = ShapeGuiTools.createAxisButton((Gui)this, toplevel, 5, 200);
        this.showOuter = ShapeGuiTools.createBoxButton((Gui)this, toplevel, 31, 200);
        this.showScan = ShapeGuiTools.createScanButton((Gui)this, toplevel, 57, 200);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.initSidePanel();
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        ((ProjectorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        this.window.event("anglemin", (source, params) -> this.min(this.angleLabel));
        this.window.event("angleplus", (source, params) -> this.plus(this.angleLabel));
        this.window.event("scalemin", (source, params) -> this.min(this.scaleLabel));
        this.window.event("scaleplus", (source, params) -> this.plus(this.scaleLabel));
        this.window.event("offsetmin", (source, params) -> this.min(this.offsetLabel));
        this.window.event("offsetplus", (source, params) -> this.plus(this.offsetLabel));
    }

    private void initSidePanel() {
        Panel sidePanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(sideBackground);
        this.initRsPanel(sidePanel, 0, "S");
        this.initRsPanel(sidePanel, 1, "N");
        this.initRsPanel(sidePanel, 2, "E");
        this.initRsPanel(sidePanel, 3, "W");
        sidePanel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, 80, this.field_147000_g));
        this.sideWindow = new Window((GuiScreen)this, (AbstractContainerWidget)sidePanel);
    }

    private void initRsPanel(Panel sidePanel, int o, String label) {
        int dy = o * 53;
        sidePanel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(label)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, dy + 8, 12, 13)));
        ImageLabel redstoneOn = (ImageLabel)new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 16, 96);
        redstoneOn.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, dy + 8, 16, 16));
        ImageLabel redstoneOff = (ImageLabel)new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 0, 96);
        redstoneOff.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(54, dy + 8, 16, 16));
        ((Panel)sidePanel.addChild((Widget)redstoneOn)).addChild((Widget)redstoneOff);
        this.rsLabelOn[o] = new ChoiceLabel(this.field_146297_k, (Gui)this);
        this.rsLabelOn[o].addChoices(ProjectorOpcode.getChoices());
        this.rsLabelOn[o].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, dy + 26, 32, 14));
        for (ProjectorOpcode operation : ProjectorOpcode.values()) {
            this.rsLabelOn[o].setChoiceTooltip(operation.getCode(), new String[]{operation.getDescription()});
        }
        sidePanel.addChild((Widget)this.rsLabelOn[o]);
        this.rsLabelOff[o] = new ChoiceLabel(this.field_146297_k, (Gui)this);
        this.rsLabelOff[o].addChoices(ProjectorOpcode.getChoices());
        this.rsLabelOff[o].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(42, dy + 26, 32, 14));
        for (ProjectorOpcode operation : ProjectorOpcode.values()) {
            this.rsLabelOff[o].setChoiceTooltip(operation.getCode(), new String[]{operation.getDescription()});
        }
        sidePanel.addChild((Widget)this.rsLabelOff[o]);
        this.valOn[o] = new TextField(this.field_146297_k, (Gui)this);
        this.valOn[o].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, dy + 41, 32, 14));
        sidePanel.addChild((Widget)this.valOn[o]);
        this.valOff[o] = new TextField(this.field_146297_k, (Gui)this);
        this.valOff[o].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(42, dy + 41, 32, 14));
        sidePanel.addChild((Widget)this.valOff[o]);
        this.rsLabelOn[o].addChoiceEvent((parent, newChoice) -> this.updateRs());
        this.rsLabelOff[o].addChoiceEvent((parent, newChoice) -> this.updateRs());
        this.valOn[o].addTextEvent((parent, newText) -> this.updateRs());
        this.valOff[o].addTextEvent((parent, newText) -> this.updateRs());
        ProjectorOperation op = ((ProjectorTileEntity)this.tileEntity).getOperations()[o];
        this.rsLabelOn[o].setChoice(op.getOpcodeOn().getCode());
        this.rsLabelOff[o].setChoice(op.getOpcodeOff().getCode());
        this.valOn[o].setText(op.getValueOn() == null ? "" : op.getValueOn().toString());
        this.valOff[o].setText(op.getValueOff() == null ? "" : op.getValueOff().toString());
    }

    private void updateRs() {
        TypedMap.Builder builder = TypedMap.builder();
        for (int i = 0; i < 4; ++i) {
            builder.put(ProjectorTileEntity.PARAM_OPON.get(i), (Object)this.rsLabelOn[i].getCurrentChoice());
            builder.put(ProjectorTileEntity.PARAM_OPOFF.get(i), (Object)this.rsLabelOff[i].getCurrentChoice());
            String text = this.valOn[i].getText();
            if (!text.trim().isEmpty()) {
                try {
                    builder.put(ProjectorTileEntity.PARAM_VALON.get(i), (Object)Double.parseDouble(text));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((text = this.valOff[i].getText()).trim().isEmpty()) continue;
            try {
                builder.put(ProjectorTileEntity.PARAM_VALOFF.get(i), (Object)Double.parseDouble(text));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "projector.rsSettings", builder.build());
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
    }

    private void plus(ScrollableLabel l) {
        l.setRealValue(l.getRealValue() + 1);
    }

    private void min(ScrollableLabel l) {
        l.setRealValue(l.getRealValue() - 1);
    }

    private void update() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "projector.settings", TypedMap.builder().put(ProjectorTileEntity.PARAM_SCALE, (Object)this.scaleLabel.getRealValue()).put(ProjectorTileEntity.PARAM_OFFSET, (Object)this.offsetLabel.getRealValue()).put(ProjectorTileEntity.PARAM_ANGLE, (Object)this.angleLabel.getRealValue()).put(ProjectorTileEntity.PARAM_AUTO, (Object)this.autoRotate.isPressed()).put(ProjectorTileEntity.PARAM_SCAN, (Object)this.scanline.isPressed()).put(ProjectorTileEntity.PARAM_SOUND, (Object)this.sound.isPressed()).put(ProjectorTileEntity.PARAM_GRAY, (Object)this.grayScale.isPressed()).build());
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.field_147003_i, y -= this.field_147009_r);
    }

    @Override
    public int getPreviewLeft() {
        return this.getGuiLeft();
    }

    @Override
    public int getPreviewTop() {
        return this.getGuiTop();
    }

    protected void func_146976_a(float v, int x, int y) {
        this.getShapeRenderer().handleMouseWheel();
        for (int i = 0; i < 4; ++i) {
            ProjectorOperation op = ((ProjectorTileEntity)this.tileEntity).getOperations()[i];
            this.valOn[i].setEnabled(op.getOpcodeOn().isNeedsValue());
            this.valOff[i].setEnabled(op.getOpcodeOff().isNeedsValue());
        }
        this.sound.setEnabled(this.scanline.isPressed());
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ProjectorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        ItemStack stack = ((ProjectorTileEntity)this.tileEntity).getRenderStack();
        if (!stack.func_190926_b()) {
            this.getShapeRenderer().setShapeID(((ProjectorTileEntity)this.tileEntity).getShapeID());
            this.getShapeRenderer().renderShape(this, stack, this.field_147003_i, this.field_147009_r, this.showAxis.isPressed(), this.showOuter.isPressed(), this.showScan.isPressed(), false);
        }
    }
}

