/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.security.GuiSecurityManager;
import mcjty.rftools.blocks.security.SecurityChannels;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSecurityInfoReady
implements IMessage {
    private SecurityChannels.SecurityChannel channel;

    public void fromBytes(ByteBuf buf) {
        this.channel = new SecurityChannels.SecurityChannel();
        this.channel.setName(NetworkTools.readString((ByteBuf)buf));
        this.channel.setWhitelist(buf.readBoolean());
        int size = buf.readInt();
        this.channel.clearPlayers();
        for (int i = 0; i < size; ++i) {
            this.channel.addPlayer(NetworkTools.readString((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.channel.getName());
        buf.writeBoolean(this.channel.isWhitelist());
        List<String> players = this.channel.getPlayers();
        buf.writeInt(players.size());
        for (String player : players) {
            NetworkTools.writeString((ByteBuf)buf, (String)player);
        }
    }

    public PacketSecurityInfoReady() {
    }

    public PacketSecurityInfoReady(SecurityChannels.SecurityChannel channel) {
        this.channel = channel;
    }

    public static class Handler
    implements IMessageHandler<PacketSecurityInfoReady, IMessage> {
        public IMessage onMessage(PacketSecurityInfoReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSecurityInfoReady message, MessageContext ctx) {
            GuiSecurityManager.channelFromServer = message.channel;
        }
    }
}

