/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient.helper;

import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.RenderHelper;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.ILevelRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ScreenLevelHelper
implements ILevelRenderHelper {
    private boolean hidebar = false;
    private boolean hidetext = false;
    private boolean showdiff = false;
    private boolean showpct = false;
    private FormatStyle formatStyle = FormatStyle.MODE_FULL;
    private int poscolor = 0xFFFFFF;
    private int negcolor = 0xFFFFFF;
    private int gradient1 = -65536;
    private int gradient2 = -13421824;
    private String label = "";
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    @Override
    public void render(int x, int y, @Nullable IModuleDataContents data, @Nonnull ModuleRenderInfo renderInfo) {
        if (data == null) {
            return;
        }
        long maxContents = data.getMaxContents();
        if (maxContents > 0L && !this.hidebar) {
            int width;
            long contents = data.getContents();
            long value = contents * (long)(width = 80 - x + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((int)x, (int)y, (int)((int)((long)x + value)), (int)(y + 8), (int)this.gradient1, (int)this.gradient2);
        }
        if (!this.hidetext) {
            String diffTxt = null;
            int col = this.poscolor;
            if (this.showdiff) {
                long diff = data.getLastPerTick();
                if (diff < 0L) {
                    col = this.negcolor;
                    diffTxt = diff + " " + this.label + "/t";
                } else {
                    diffTxt = "+" + diff + " " + this.label + "/t";
                }
            } else if (maxContents > 0L) {
                long contents = data.getContents();
                if (this.showpct) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    diffTxt = value + "%";
                } else {
                    diffTxt = this.format(String.valueOf(contents), this.formatStyle) + this.label;
                }
            }
            if (diffTxt != null) {
                if (renderInfo.font != null) {
                    float r = (float)(col >> 16 & 0xFF) / 255.0f;
                    float g = (float)(col >> 8 & 0xFF) / 255.0f;
                    float b = (float)(col & 0xFF) / 255.0f;
                    renderInfo.font.drawString((float)x, (float)(128 - y), diffTxt, 0.25f, 0.25f, -552.0f, new float[]{r, g, b, 1.0f});
                } else {
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    fontRenderer.func_78276_b(diffTxt, x, y, col);
                }
            }
        }
    }

    @Override
    public ILevelRenderHelper label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public ILevelRenderHelper settings(boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff) {
        this.hidebar = hidebar;
        this.hidetext = hidetext;
        this.showpct = showpct;
        this.showdiff = showdiff;
        return this;
    }

    @Override
    public ILevelRenderHelper color(int poscolor, int negcolor) {
        this.poscolor = poscolor;
        this.negcolor = negcolor;
        return this;
    }

    @Override
    public ILevelRenderHelper gradient(int gradient1, int gradient2) {
        this.gradient1 = gradient1;
        this.gradient2 = gradient2;
        return this;
    }

    @Override
    public ILevelRenderHelper format(FormatStyle formatStyle) {
        this.formatStyle = formatStyle;
        return this;
    }

    private String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

