/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient.helper;

import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderHelper;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.ILevelRenderHelper;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenLevelHelper;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import mcjty.rftools.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ClientScreenModuleHelper
implements IModuleRenderHelper {
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    @Override
    public void renderLevel(FontRenderer fontRenderer, int xoffset, int currenty, IModuleDataContents screenData, String label, boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff, int poscolor, int negcolor, int gradient1, int gradient2, FormatStyle formatStyle) {
        this.renderLevel(fontRenderer, xoffset, currenty, screenData, label, hidebar, hidetext, showpct, showdiff, poscolor, negcolor, gradient1, gradient2, formatStyle, null);
    }

    private void renderLevel(FontRenderer fontRenderer, int xoffset, int currenty, IModuleDataContents screenData, String label, boolean hidebar, boolean hidetext, boolean showpct, boolean showdiff, int poscolor, int negcolor, int gradient1, int gradient2, FormatStyle formatStyle, ModuleRenderInfo renderInfo) {
        if (screenData == null) {
            return;
        }
        long maxContents = screenData.getMaxContents();
        if (maxContents > 0L && !hidebar) {
            int width;
            long contents = screenData.getContents();
            long value = contents * (long)(width = 80 - xoffset + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((int)xoffset, (int)currenty, (int)((int)((long)xoffset + value)), (int)(currenty + 8), (int)gradient1, (int)gradient2);
        }
        if (!hidetext) {
            String diffTxt = null;
            int col = poscolor;
            if (showdiff) {
                long diff = screenData.getLastPerTick();
                if (diff < 0L) {
                    col = negcolor;
                    diffTxt = diff + " " + label + "/t";
                } else {
                    diffTxt = "+" + diff + " " + label + "/t";
                }
            } else if (maxContents > 0L) {
                long contents = screenData.getContents();
                if (showpct) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    diffTxt = value + "%";
                } else {
                    diffTxt = this.format(String.valueOf(contents), formatStyle) + label;
                }
            }
            if (diffTxt != null) {
                if (ScreenConfiguration.useTruetype) {
                    float r = (float)(col >> 16 & 0xFF) / 255.0f;
                    float g = (float)(col >> 8 & 0xFF) / 255.0f;
                    float b = (float)(col & 0xFF) / 255.0f;
                    ClientProxy.font.drawString((float)xoffset, (float)(128 - currenty), diffTxt, 0.25f, 0.25f, -552.0f, new float[]{r, g, b, 1.0f});
                } else {
                    fontRenderer.func_78276_b(diffTxt, xoffset, currenty, col);
                }
            }
        }
    }

    @Override
    public ITextRenderHelper createTextRenderHelper() {
        return new ScreenTextHelper();
    }

    @Override
    public ILevelRenderHelper createLevelRenderHelper() {
        return new ScreenLevelHelper();
    }

    @Override
    public void renderText(int x, int y, int color, @Nonnull ModuleRenderInfo renderInfo, String text) {
        if (text == null) {
            return;
        }
        if (renderInfo.font != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderInfo.font.drawString((float)x, (float)(128 - y), text, 0.25f, 0.25f, -552.0f, new float[]{r, g, b, 1.0f});
        } else {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_78276_b(text, x, y, color);
        }
    }

    @Override
    public void renderTextTrimmed(int x, int y, int color, @Nonnull ModuleRenderInfo renderInfo, String text, int maxwidth) {
        if (text == null) {
            return;
        }
        if (renderInfo.font != null) {
            String trimmed = renderInfo.font.trimStringToWidth(text, maxwidth);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderInfo.font.drawString((float)x, (float)(128 - y), trimmed, 0.25f, 0.25f, -552.0f, new float[]{r, g, b, 1.0f});
        } else {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String trimmed = fontRenderer.func_78269_a(text, maxwidth / 4);
            fontRenderer.func_78276_b(trimmed, x, y, color);
        }
    }

    @Override
    public String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

