/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

public enum RFMonitorMode {
    MODE_OFF(0, "Off"),
    MODE_LESS(1, "Less"),
    MODE_MORE(2, "More");

    private final int index;
    private final String description;

    private RFMonitorMode(int index, String description) {
        this.index = index;
        this.description = description;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDescription() {
        return this.description;
    }

    public static RFMonitorMode getModeFromIndex(int index) {
        for (RFMonitorMode mode : RFMonitorMode.values()) {
            if (mode.getIndex() != index) continue;
            return mode;
        }
        return MODE_OFF;
    }

    public static RFMonitorMode getModeFromDescription(String description) {
        for (RFMonitorMode mode : RFMonitorMode.values()) {
            if (!description.equals(mode.getDescription())) continue;
            return mode;
        }
        return MODE_OFF;
    }
}

