/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.infuser;

import mcjty.lib.api.Infusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.infuser.MachineInfuserConfiguration;
import mcjty.rftools.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class MachineInfuserTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModItems.dimensionalShardItem)}), "container", 0, 64, 24, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_OUTPUT, new ItemStack[0]), "container", 1, 118, 24, 1, 18, 1, 18);
            this.layoutPlayerInventorySlots(10, 70);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 2);
    private int infusing = 0;

    public MachineInfuserTileEntity() {
        super((long)MachineInfuserConfiguration.MAXENERGY, (long)MachineInfuserConfiguration.RECEIVEPERTICK);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.infusing > 0) {
            --this.infusing;
            if (this.infusing == 0) {
                ItemStack outputStack = this.inventoryHelper.getStackInSlot(1);
                this.finishInfusing(outputStack);
            }
            this.func_70296_d();
        } else {
            ItemStack inputStack = this.inventoryHelper.getStackInSlot(0);
            ItemStack outputStack = this.inventoryHelper.getStackInSlot(1);
            if (!inputStack.func_190926_b() && inputStack.func_77973_b() == ModItems.dimensionalShardItem && this.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    private boolean isInfusable(ItemStack stack) {
        NBTTagCompound tagCompound = MachineInfuserTileEntity.getTagCompound(stack);
        if (tagCompound == null) {
            return false;
        }
        int infused = tagCompound.func_74762_e("infused");
        return infused < GeneralConfig.maxInfuse;
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (stack.func_190916_E() != 1) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        Block block = ((ItemBlock)item).func_179223_d();
        if (!(block instanceof Infusable || block instanceof GenericBlock && ((GenericBlock)block).isInfusable())) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new NBTTagCompound();
        }
        return tagCompound;
    }

    private void finishInfusing(ItemStack stack) {
        NBTTagCompound tagCompound = MachineInfuserTileEntity.getTagCompound(stack);
        if (tagCompound == null) {
            return;
        }
        int infused = tagCompound.func_74762_e("infused");
        tagCompound.func_74768_a("infused", infused + 1);
        stack.func_77982_d(tagCompound);
    }

    private void startInfusing() {
        int rf = MachineInfuserConfiguration.rfPerTick;
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getStoredPower() < (long)rf) {
            return;
        }
        this.consumeEnergy(rf);
        this.inventoryHelper.getStackInSlot(0).func_77979_a(1);
        if (this.inventoryHelper.getStackInSlot(0).func_190926_b()) {
            this.inventoryHelper.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.infusing = 5;
        this.func_70296_d();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index) || CONTAINER_FACTORY.isSpecificItemSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 0 || stack.func_77973_b() == ModItems.dimensionalShardItem;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.infusing = tagCompound.func_74762_e("infusing");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("infusing", this.infusing);
    }
}

