/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.blocks.endergen.PearlInjectorTileEntity;
import mcjty.rftools.blocks.logic.sequencer.SequencerTileEntity;
import mcjty.rftools.blocks.logic.timer.TimerTileEntity;

public class TickOrderHandler {
    private static List<PearlInjectorTileEntity> pearlInjectors = new ArrayList<PearlInjectorTileEntity>();
    private static List<EndergenicTileEntity> connectedEndergenics = new ArrayList<EndergenicTileEntity>();
    private static List<EndergenicTileEntity> endergenics = new ArrayList<EndergenicTileEntity>();
    private static List<SequencerTileEntity> sequencers = new ArrayList<SequencerTileEntity>();
    private static List<TimerTileEntity> timers = new ArrayList<TimerTileEntity>();
    private static List<EnderMonitorTileEntity> enderMonitors = new ArrayList<EnderMonitorTileEntity>();

    private TickOrderHandler() {
    }

    public static void clean() {
        pearlInjectors.clear();
        connectedEndergenics.clear();
        endergenics.clear();
        sequencers.clear();
        timers.clear();
        enderMonitors.clear();
    }

    public static void queuePearlInjector(PearlInjectorTileEntity pearlInjector) {
        pearlInjectors.add(pearlInjector);
        for (EndergenicTileEntity endergenic = pearlInjector.findEndergenicTileEntity(); endergenic != null && !connectedEndergenics.contains(endergenic); endergenic = endergenic.getDestinationTE()) {
            connectedEndergenics.add(endergenic);
        }
    }

    public static void queueEndergenic(EndergenicTileEntity endergenic) {
        endergenics.add(endergenic);
    }

    public static void queueSequencer(SequencerTileEntity sequencer) {
        sequencers.add(sequencer);
    }

    public static void queueTimer(TimerTileEntity timer) {
        timers.add(timer);
    }

    public static void queueEnderMonitor(EnderMonitorTileEntity enderMonitor) {
        enderMonitors.add(enderMonitor);
    }

    private static <T extends ICheckStateServer> List<T> checkStateServer(int dimension, List<T> tileEntities) {
        ArrayList<ICheckStateServer> remainingTes = new ArrayList<ICheckStateServer>();
        for (ICheckStateServer tileEntity : tileEntities) {
            if (tileEntity.getDimension() == dimension) {
                tileEntity.checkStateServer();
                continue;
            }
            remainingTes.add(tileEntity);
        }
        return remainingTes;
    }

    static void postWorldTick(int dimension) {
        pearlInjectors = TickOrderHandler.checkStateServer(dimension, pearlInjectors);
        endergenics.removeAll(connectedEndergenics);
        connectedEndergenics = TickOrderHandler.checkStateServer(dimension, connectedEndergenics);
        endergenics = TickOrderHandler.checkStateServer(dimension, endergenics);
        enderMonitors = TickOrderHandler.checkStateServer(dimension, enderMonitors);
        timers = TickOrderHandler.checkStateServer(dimension, timers);
        sequencers = TickOrderHandler.checkStateServer(dimension, sequencers);
    }

    public static interface ICheckStateServer {
        public void checkStateServer();

        public int getDimension();
    }
}

