/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import javax.annotation.Nullable;
import mcjty.lib.varia.EnergyTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlockInfo {
    private BlockPos coordinate;
    private long storedPower;
    private long capacity;

    public BlockInfo(TileEntity tileEntity, @Nullable EnumFacing side, BlockPos coordinate) {
        this.coordinate = coordinate;
        this.fetchEnergyValues(tileEntity, side);
    }

    public BlockInfo(BlockPos coordinate, long storedPower, long capacity) {
        this.coordinate = coordinate;
        this.storedPower = storedPower;
        this.capacity = capacity;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    private void fetchEnergyValues(TileEntity tileEntity, @Nullable EnumFacing side) {
        EnergyTools.EnergyLevel energyLevel = EnergyTools.getEnergyLevel((TileEntity)tileEntity, (EnumFacing)side);
        this.capacity = energyLevel.getMaxEnergy();
        this.storedPower = energyLevel.getEnergy();
    }

    public long getStoredPower() {
        return this.storedPower;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        if (this.storedPower != blockInfo.storedPower) {
            return false;
        }
        if (this.capacity != blockInfo.capacity) {
            return false;
        }
        return !(this.coordinate != null ? !this.coordinate.equals((Object)blockInfo.coordinate) : blockInfo.coordinate != null);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + Long.hashCode(this.storedPower);
        result = 31 * result + Long.hashCode(this.capacity);
        return result;
    }
}

