/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile.routing;

import WayofTime.bloodmagic.item.routing.IFluidFilterProvider;
import WayofTime.bloodmagic.item.routing.IItemFilterProvider;
import WayofTime.bloodmagic.routing.DefaultItemFilter;
import WayofTime.bloodmagic.routing.IFluidFilter;
import WayofTime.bloodmagic.routing.IInputFluidRoutingNode;
import WayofTime.bloodmagic.routing.IInputItemRoutingNode;
import WayofTime.bloodmagic.routing.IItemFilter;
import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import WayofTime.bloodmagic.util.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TileInputRoutingNode
extends TileFilteredRoutingNode
implements IInputItemRoutingNode,
IInputFluidRoutingNode {
    public TileInputRoutingNode() {
        super(6, "inputNode");
    }

    @Override
    public boolean isInput(EnumFacing side) {
        return true;
    }

    @Override
    public IItemFilter getInputFilterForSide(EnumFacing side) {
        IItemHandler handler;
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile != null && (handler = Utils.getInventory(tile, side.func_176734_d())) != null) {
            ItemStack filterStack = this.getFilterStack(side);
            if (filterStack.func_190926_b()) {
                DefaultItemFilter filter = new DefaultItemFilter();
                filter.initializeFilter(null, tile, handler, false);
                return filter;
            }
            if (!(filterStack.func_77973_b() instanceof IItemFilterProvider)) {
                return null;
            }
            IItemFilterProvider filter = (IItemFilterProvider)filterStack.func_77973_b();
            return filter.getInputItemFilter(filterStack, tile, handler);
        }
        return null;
    }

    @Override
    public boolean isFluidInput(EnumFacing side) {
        return true;
    }

    @Override
    public IFluidFilter getInputFluidFilterForSide(EnumFacing side) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            ItemStack filterStack = this.getFilterStack(side);
            if (filterStack == null || !(filterStack.func_77973_b() instanceof IFluidFilterProvider)) {
                return null;
            }
            return ((IFluidFilterProvider)filterStack.func_77973_b()).getInputFluidFilter(filterStack, tile, handler);
        }
        return null;
    }

    @Override
    public boolean isTankConnectedToSide(EnumFacing side) {
        return true;
    }
}

