/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.teleport;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.event.TeleposeEvent;
import WayofTime.bloodmagic.teleport.Teleport;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Teleports {
    public static SoulTicket ticket(World world, Entity entity, int amount) {
        return new SoulTicket((ITextComponent)new TextComponentString("teleport|" + world.field_73011_w.getDimension() + "|" + entity.func_70005_c_() + "|" + entity.func_180425_c().func_177986_g()), amount);
    }

    public static class TeleportToDim
    extends Teleport {
        private World oldWorld;
        private int newWorldID;
        private boolean teleposer;

        public TeleportToDim(int x, int y, int z, Entity entity, UUID networkOwner, World oldWorld, int newWorld, boolean teleposer) {
            this(new BlockPos(x, y, z), entity, networkOwner, oldWorld, newWorld, teleposer);
        }

        public TeleportToDim(BlockPos blockPos, Entity entity, UUID networkOwner, World oldWorld, int newWorldID, boolean teleposer) {
            super(blockPos, entity, networkOwner);
            this.oldWorld = oldWorld;
            this.newWorldID = newWorldID;
            this.teleposer = teleposer;
        }

        @Override
        public void teleport() {
            if (this.entity != null) {
                if (this.entity.field_71088_bW <= 0) {
                    this.entity.field_71088_bW = 10;
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    WorldServer oldWorldServer = server.func_71218_a(this.entity.field_71093_bK);
                    WorldServer newWorldServer = server.func_71218_a(this.newWorldID);
                    BlockPos targetTeleposer = new BlockPos(this.x, this.y, this.z);
                    ChunkPos teleposerChunk = new ChunkPos(targetTeleposer);
                    ForgeChunkManager.Ticket chunkTicket = ForgeChunkManager.requestTicket((Object)"bloodmagic", (World)newWorldServer, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)chunkTicket, (ChunkPos)teleposerChunk);
                    if (this.entity instanceof EntityPlayer) {
                        EntityPlayerMP player = (EntityPlayerMP)this.entity;
                        if (!player.func_130014_f_().field_72995_K) {
                            SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkOwner);
                            if (network.getCurrentEssence() < this.getTeleportCost()) {
                                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
                                return;
                            }
                            if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), (World)newWorldServer, targetTeleposer))) {
                                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
                                return;
                            }
                            network.syphon(Teleports.ticket(this.oldWorld, (Entity)player, this.getTeleportCost()));
                            PlayerList playerList = server.func_184103_al();
                            player.field_71093_bK = this.newWorldID;
                            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, newWorldServer.func_175659_aa(), newWorldServer.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                            playerList.func_187243_f(player);
                            oldWorldServer.func_72973_f((Entity)player);
                            player.field_70128_L = false;
                            player.func_70012_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, player.field_70177_z, player.field_70125_A);
                            player.field_71135_a.func_147364_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, player.field_70177_z, player.field_70125_A);
                            newWorldServer.func_72838_d((Entity)player);
                            newWorldServer.func_72866_a((Entity)player, false);
                            player.func_70029_a((World)newWorldServer);
                            playerList.func_72375_a(player, oldWorldServer);
                            player.field_71135_a.func_147364_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, player.field_70177_z, player.field_70125_A);
                            player.field_71134_c.func_73080_a(newWorldServer);
                            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                            playerList.func_72354_b(player, newWorldServer);
                            playerList.func_72385_f(player);
                            for (PotionEffect potioneffect : player.func_70651_bq()) {
                                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
                            }
                            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, this.entity.field_71093_bK, this.newWorldID);
                            player.func_70012_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, player.field_70177_z, player.field_70125_A);
                            if (this.teleposer) {
                                MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), (World)newWorldServer, targetTeleposer));
                            }
                        }
                    } else if (!this.entity.func_130014_f_().field_72995_K) {
                        SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkOwner);
                        if (network.getCurrentEssence() < this.getTeleportCost() / 10) {
                            return;
                        }
                        if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), (World)newWorldServer, targetTeleposer))) {
                            return;
                        }
                        network.syphon(Teleports.ticket(this.oldWorld, this.entity, this.getTeleportCost() / 10));
                        NBTTagCompound tag = new NBTTagCompound();
                        this.entity.func_70039_c(tag);
                        this.entity.func_70106_y();
                        this.oldWorld.func_184134_a(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                        Entity teleportedEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)newWorldServer);
                        if (teleportedEntity != null) {
                            teleportedEntity.func_70012_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, this.entity.field_70177_z, this.entity.field_70125_A);
                            teleportedEntity.field_98038_p = true;
                            newWorldServer.func_72838_d(teleportedEntity);
                            teleportedEntity.func_70029_a((World)newWorldServer);
                        }
                        oldWorldServer.func_82742_i();
                        newWorldServer.func_82742_i();
                        if (this.teleposer) {
                            MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), (World)newWorldServer, targetTeleposer));
                        }
                    }
                    newWorldServer.func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
                } else {
                    this.entity.field_71088_bW = 10;
                }
            }
        }

        @Override
        public int getTeleportCost() {
            return 10000;
        }

        public World getOldWorld() {
            return this.oldWorld;
        }

        public int getNewWorldID() {
            return this.newWorldID;
        }

        public boolean isTeleposer() {
            return this.teleposer;
        }
    }

    public static class TeleportSameDim
    extends Teleport {
        private final boolean teleposer;

        public TeleportSameDim(int x, int y, int z, Entity entity, UUID networkOwner, boolean teleposer) {
            this(new BlockPos(x, y, z), entity, networkOwner, teleposer);
        }

        public TeleportSameDim(BlockPos blockPos, Entity entity, UUID networkOwner, boolean teleposer) {
            super(blockPos, entity, networkOwner);
            this.teleposer = teleposer;
        }

        @Override
        public void teleport() {
            if (this.entity != null) {
                BlockPos targetTeleposer = new BlockPos(this.x, this.y, this.z);
                if (this.entity.field_71088_bW <= 0) {
                    this.entity.field_71088_bW = 10;
                    if (this.entity instanceof EntityPlayer) {
                        SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkOwner);
                        if (network.getCurrentEssence() < this.getTeleportCost()) {
                            return;
                        }
                        if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), this.entity.func_130014_f_(), targetTeleposer))) {
                            return;
                        }
                        EntityPlayerMP player = (EntityPlayerMP)this.entity;
                        network.syphon(Teleports.ticket(this.entity.field_70170_p, (Entity)player, this.getTeleportCost()));
                        player.func_70634_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
                        player.func_130014_f_().func_72866_a((Entity)player, false);
                        player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                        player.func_130014_f_().func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                        if (this.teleposer) {
                            MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), this.entity.func_130014_f_(), targetTeleposer));
                        }
                    } else {
                        SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkOwner);
                        if (network.getCurrentEssence() < this.getTeleportCost() / 10) {
                            return;
                        }
                        if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), this.entity.func_130014_f_(), targetTeleposer))) {
                            return;
                        }
                        WorldServer world = (WorldServer)this.entity.func_130014_f_();
                        network.syphon(Teleports.ticket((World)world, this.entity, this.getTeleportCost() / 10));
                        this.entity.func_70107_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
                        world.func_82742_i();
                        this.entity.func_130014_f_().func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                        if (this.teleposer) {
                            MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.func_130014_f_(), this.entity.func_180425_c(), this.entity.func_130014_f_(), targetTeleposer));
                        }
                    }
                } else {
                    this.entity.field_71088_bW = 10;
                }
            }
        }

        @Override
        public int getTeleportCost() {
            return 1000;
        }
    }
}

