/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="grounding")
public class RitualGrounding
extends Ritual {
    public static final int willRefreshTime = 20;
    public static final String GROUNDING_RANGE = "groundingRange";
    public static final double willDrain = 0.5;

    public RitualGrounding() {
        super("ritualGrounding", 0, 5000, "ritual.bloodmagic.groundingRitual");
        this.addBlockRange(GROUNDING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, 0, -10), 21, 30, 21));
        this.setMaximumVolumeAndDistanceOfRange(GROUNDING_RANGE, 0, 200, 200);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double rawDrained = 0.0;
        double corrosiveDrained = 0.0;
        double destructiveDrained = 0.0;
        double steadfastDrained = 0.0;
        double vengefulDrained = 0.0;
        AreaDescriptor groundingRange = this.getBlockRange(GROUNDING_RANGE);
        List entities = world.func_72872_a(EntityLivingBase.class, groundingRange.getAABB(pos));
        for (EntityLivingBase entity : entities) {
            double[] drainagePlayer;
            if (totalEffects >= maxEffects) break;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) continue;
            ++totalEffects;
            if (entity instanceof EntityPlayer) {
                if (world.func_82737_E() % 10L != 0L || !(rawWill >= 0.5)) continue;
                rawDrained += 0.5;
                drainagePlayer = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
                corrosiveDrained += drainagePlayer[0];
                destructiveDrained += drainagePlayer[1];
                vengefulDrained += drainagePlayer[2];
                continue;
            }
            if (entity.func_184222_aU()) {
                if (world.func_82737_E() % 10L != 0L) continue;
                double[] drainageEntity = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
                corrosiveDrained += drainageEntity[0];
                destructiveDrained += drainageEntity[1];
                vengefulDrained += drainageEntity[2];
                continue;
            }
            if (entity.func_184222_aU() || !(steadfastWill >= 0.5)) continue;
            if (entity instanceof EntityWither || entity instanceof EntityDragon) {
                entity.func_70091_d(MoverType.SELF, 0.0, -0.05, 0.0);
            }
            steadfastDrained += 0.05;
            drainagePlayer = this.sharedWillEffects(world, entity, corrosiveWill, destructiveWill, vengefulWill, corrosiveDrained, destructiveDrained, vengefulDrained);
            corrosiveDrained += drainagePlayer[0];
            destructiveDrained += drainagePlayer[1];
            vengefulDrained += drainagePlayer[2];
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        if (corrosiveDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
        }
        if (destructiveDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrained, true);
        }
        if (steadfastDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
        }
        if (vengefulDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return Math.max(1, this.getBlockRange(GROUNDING_RANGE).getVolume() / 10000);
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 2, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 3, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualGrounding();
    }

    public double[] sharedWillEffects(World world, EntityLivingBase entity, double corrosiveWill, double destructiveWill, double vengefulWill, double corrosiveDrained, double destructiveDrained, double vengefulDrained) {
        if (corrosiveWill >= 0.5 && vengefulWill >= 0.5) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 20, 10));
            vengefulDrained += 0.5;
            corrosiveDrained += 0.5;
        } else if (corrosiveWill >= 0.5) {
            entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.SUSPENDED, 20, 0));
            corrosiveDrained += 0.5;
        } else if (vengefulWill >= 0.5) {
            vengefulDrained += 0.5;
            entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.GROUNDED, 40, 20));
        } else {
            entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.GROUNDED, 20, 10));
        }
        if (destructiveWill >= 0.5) {
            destructiveDrained += 0.5;
            if (vengefulWill >= 0.5 + vengefulDrained) {
                if (world.func_82737_E() % 100L == 0L) {
                    vengefulDrained += 0.5;
                    entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.HEAVY_HEART, 200, 2));
                }
            } else if (world.func_82737_E() % 50L == 0L) {
                entity.func_70690_d(new PotionEffect(RegistrarBloodMagic.HEAVY_HEART, 100, 1));
            }
        }
        return new double[]{corrosiveDrained, destructiveDrained, vengefulDrained};
    }
}

