/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualManager;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@RitualRegister(value="forsaken_soul")
public class RitualForsakenSoul
extends Ritual {
    public static final String CRYSTAL_RANGE = "crystal";
    public static final String DAMAGE_RANGE = "damage";
    public static final int MAX_UNIQUENESS = 10;
    public static final int HEALTH_THRESHOLD = 20;
    public double willBuffer = 0.0;
    public double crystalBuffer = 0.0;
    public List<Integer> keyList = new ArrayList<Integer>();

    public RitualForsakenSoul() {
        super("ritualForsakenSoul", 0, 40000, "ritual.bloodmagic.forsakenSoulRitual");
        this.addBlockRange(CRYSTAL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, 2, -3), 7, 5, 7));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(CRYSTAL_RANGE, 250, 5, 7);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 10, 10);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.willBuffer = tag.func_74769_h("willBuffer");
        this.crystalBuffer = tag.func_74769_h("crystalBuffer");
        this.keyList.clear();
        for (int i = 0; i < 10; ++i) {
            String key = "uniq" + i;
            if (!tag.func_74764_b(key)) continue;
            this.keyList.add(tag.func_74762_e(key));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("willBuffer", this.willBuffer);
        tag.func_74780_a("crystalBuffer", this.crystalBuffer);
        for (int i = 0; i < Math.min(10, this.keyList.size()); ++i) {
            String key = "uniq" + i;
            tag.func_74768_a(key, this.keyList.get(i).intValue());
        }
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = 100;
        int totalEffects = 0;
        ArrayList<TileDemonCrystal> crystalList = new ArrayList<TileDemonCrystal>();
        AreaDescriptor crystalRange = masterRitualStone.getBlockRange(CRYSTAL_RANGE);
        crystalRange.resetIterator();
        while (crystalRange.hasNext()) {
            BlockPos nextPos = ((BlockPos)crystalRange.next()).func_177971_a((Vec3i)pos);
            TileEntity tile = world.func_175625_s(nextPos);
            if (!(tile instanceof TileDemonCrystal)) continue;
            crystalList.add((TileDemonCrystal)tile);
        }
        AreaDescriptor damageRange = masterRitualStone.getBlockRange(DAMAGE_RANGE);
        AxisAlignedBB range = damageRange.getAABB(pos);
        List entities = world.func_72872_a(EntityLivingBase.class, range);
        for (EntityLivingBase entity : entities) {
            EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
            if (entityEntry == null || BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(entityEntry.getRegistryName()) || !entity.func_70089_S() || entity instanceof EntityPlayer || !entity.func_70097_a(RitualManager.RITUAL_DAMAGE, 1.0f) || entity.func_70089_S()) continue;
            int uniqueness = this.calculateUniqueness(entity);
            double modifier = 1.0;
            if (entity instanceof EntityAnimal && !((EntityAnimal)entity).field_70132_H) {
                modifier = 4.0;
            }
            this.willBuffer += modifier * this.getWillForUniqueness(uniqueness) / 20.0 * (double)entity.func_110138_aP();
            this.crystalBuffer += modifier * (double)entity.func_110138_aP() / 20.0;
            if (++totalEffects < maxEffects) continue;
            break;
        }
        if (crystalList.size() > 0 && this.crystalBuffer > 0.0) {
            double growth = Math.min(this.crystalBuffer, 1.0);
            double willSyphonAmount = growth * this.willBuffer / this.crystalBuffer;
            TileDemonCrystal chosenCrystal = (TileDemonCrystal)((Object)crystalList.get(world.field_73012_v.nextInt(crystalList.size())));
            double percentageGrowth = chosenCrystal.growCrystalWithWillAmount(growth * this.willBuffer / this.crystalBuffer, growth);
            if (percentageGrowth > 0.0) {
                this.crystalBuffer -= percentageGrowth;
                this.willBuffer -= percentageGrowth * willSyphonAmount;
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    public int calculateUniqueness(EntityLivingBase mob) {
        int key = mob.getClass().hashCode();
        this.keyList.add(key);
        if (this.keyList.size() > 10) {
            this.keyList.remove(0);
        }
        ArrayList<Integer> uniquenessList = new ArrayList<Integer>();
        for (int value : this.keyList) {
            if (uniquenessList.contains(value)) continue;
            uniquenessList.add(value);
        }
        return Math.min(uniquenessList.size(), 10);
    }

    public double getWillForUniqueness(int uniqueness) {
        return Math.max(50.0 - 15.0 * Math.sqrt(uniqueness), 0.0);
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -1, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, 1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 1, 1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualForsakenSoul();
    }
}

