/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.inversion;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.BMLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class InversionPillarHandler {
    public static final double farthestDistanceSquared = 256.0;
    public static Map<Integer, Map<EnumDemonWillType, List<BlockPos>>> pillarMap = new HashMap<Integer, Map<EnumDemonWillType, List<BlockPos>>>();
    public static Map<Integer, Map<EnumDemonWillType, Map<BlockPos, List<BlockPos>>>> nearPillarMap = new HashMap<Integer, Map<EnumDemonWillType, Map<BlockPos, List<BlockPos>>>>();

    public static boolean addPillarToMap(World world, EnumDemonWillType type, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        if (pillarMap.containsKey(dim)) {
            Map<EnumDemonWillType, List<BlockPos>> willMap = pillarMap.get(dim);
            if (willMap.containsKey(type)) {
                if (!willMap.get(type).contains(pos)) {
                    willMap.get(type).add(pos);
                    InversionPillarHandler.onPillarAdded(world, type, pos);
                    return true;
                }
                return false;
            }
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            posList.add(pos);
            willMap.put(type, posList);
            InversionPillarHandler.onPillarAdded(world, type, pos);
            return true;
        }
        HashMap willMap = new HashMap();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        posList.add(pos);
        willMap.put(type, posList);
        pillarMap.put(dim, willMap);
        InversionPillarHandler.onPillarAdded(world, type, pos);
        return true;
    }

    public static boolean removePillarFromMap(World world, EnumDemonWillType type, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        if (pillarMap.containsKey(dim)) {
            Map<EnumDemonWillType, List<BlockPos>> willMap = pillarMap.get(dim);
            if (willMap.containsKey(type)) {
                if (willMap.get(type).contains(pos)) {
                    InversionPillarHandler.onPillarRemoved(world, type, pos);
                    return willMap.get(type).remove(pos);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static void onPillarAdded(World world, EnumDemonWillType type, BlockPos pos) {
        Map posMap;
        Map<EnumDemonWillType, Object> willMap;
        BMLog.DEBUG.info("Adding...", new Object[0]);
        ArrayList<BlockPos> closePosList = new ArrayList<BlockPos>();
        int dim = world.field_73011_w.getDimension();
        if (pillarMap.containsKey(dim) && (willMap = pillarMap.get(dim)).containsKey(type)) {
            List<BlockPos> otherPosList = willMap.get(type);
            for (BlockPos closePos : otherPosList) {
                if (closePos.equals((Object)pos) || !(closePos.func_177951_i((Vec3i)pos) <= 256.0)) continue;
                closePosList.add(closePos);
            }
        }
        if (nearPillarMap.containsKey(dim)) {
            willMap = nearPillarMap.get(dim);
            if (willMap.containsKey(type)) {
                posMap = (Map)willMap.get(type);
                for (BlockPos closePos : closePosList) {
                    ArrayList<BlockPos> posList = (ArrayList<BlockPos>)posMap.get(closePos);
                    if (posList != null && !posList.contains(pos)) {
                        posList.add(pos);
                        continue;
                    }
                    posList = new ArrayList<BlockPos>();
                    posList.add(pos);
                    posMap.put(closePos, posList);
                }
                posMap.put(pos, closePosList);
            } else {
                posMap = new HashMap();
                posMap.put(pos, closePosList);
                willMap.put(type, posMap);
            }
        } else {
            willMap = new HashMap<EnumDemonWillType, List<BlockPos>>();
            posMap = new HashMap<BlockPos, ArrayList<BlockPos>>();
            posMap.put(pos, closePosList);
            willMap.put(type, posMap);
            nearPillarMap.put(dim, willMap);
        }
    }

    private static void onPillarRemoved(World world, EnumDemonWillType type, BlockPos pos) {
        Map<BlockPos, List<BlockPos>> posMap;
        List<BlockPos> posList;
        Map<EnumDemonWillType, Map<BlockPos, List<BlockPos>>> willMap;
        BMLog.DEBUG.info("Removing...", new Object[0]);
        int dim = world.field_73011_w.getDimension();
        if (nearPillarMap.containsKey(dim) && (willMap = nearPillarMap.get(dim)).containsKey(type) && (posList = (posMap = willMap.get(type)).get(pos)) != null) {
            for (BlockPos checkPos : posList) {
                List<BlockPos> checkPosList = posMap.get(checkPos);
                if (checkPosList == null) continue;
                checkPosList.remove(pos);
            }
            posMap.remove(pos);
        }
    }

    public static List<BlockPos> getNearbyPillars(World world, EnumDemonWillType type, BlockPos pos) {
        Map<BlockPos, List<BlockPos>> posMap;
        List<BlockPos> posList;
        Map<EnumDemonWillType, Map<BlockPos, List<BlockPos>>> willMap;
        int dim = world.field_73011_w.getDimension();
        if (nearPillarMap.containsKey(dim) && (willMap = nearPillarMap.get(dim)).containsKey(type) && (posList = (posMap = willMap.get(type)).get(pos)) != null) {
            return posList;
        }
        return new ArrayList<BlockPos>();
    }

    public static List<BlockPos> getAllConnectedPillars(World world, EnumDemonWillType type, BlockPos pos) {
        Map<EnumDemonWillType, Map<BlockPos, List<BlockPos>>> willMap;
        ArrayList<BlockPos> checkedPosList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> uncheckedPosList = new ArrayList<BlockPos>();
        uncheckedPosList.add(pos);
        int dim = world.field_73011_w.getDimension();
        if (nearPillarMap.containsKey(dim) && (willMap = nearPillarMap.get(dim)).containsKey(type)) {
            Map<BlockPos, List<BlockPos>> posMap = willMap.get(type);
            while (!uncheckedPosList.isEmpty()) {
                ArrayList<BlockPos> newPosList = new ArrayList<BlockPos>();
                for (BlockPos checkPos : uncheckedPosList) {
                    List<BlockPos> posList = posMap.get(checkPos);
                    if (posList == null) continue;
                    for (BlockPos testPos : posList) {
                        if (checkedPosList.contains(testPos) || uncheckedPosList.contains(testPos) || newPosList.contains(testPos)) continue;
                        newPosList.add(testPos);
                    }
                }
                checkedPosList.addAll(uncheckedPosList);
                uncheckedPosList = newPosList;
            }
        }
        return checkedPosList;
    }
}

