/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedChicken;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedSheep;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedSpider;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedZombie;
import WayofTime.bloodmagic.entity.mob.EntityMimic;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.entity.projectile.EntityBloodLight;
import WayofTime.bloodmagic.entity.projectile.EntityMeteor;
import WayofTime.bloodmagic.entity.projectile.EntitySentientArrow;
import WayofTime.bloodmagic.entity.projectile.EntitySoulSnare;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.potion.PotionBloodMagic;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="bloodmagic")
@GameRegistry.ObjectHolder(value="bloodmagic")
public class RegistrarBloodMagic {
    private static final BloodOrb ORB_DEF;
    @GameRegistry.ObjectHolder(value="weak")
    public static final BloodOrb ORB_WEAK;
    @GameRegistry.ObjectHolder(value="apprentice")
    public static final BloodOrb ORB_APPRENTICE;
    @GameRegistry.ObjectHolder(value="magician")
    public static final BloodOrb ORB_MAGICIAN;
    @GameRegistry.ObjectHolder(value="master")
    public static final BloodOrb ORB_MASTER;
    @GameRegistry.ObjectHolder(value="archmage")
    public static final BloodOrb ORB_ARCHMAGE;
    @GameRegistry.ObjectHolder(value="transcendent")
    public static final BloodOrb ORB_TRANSCENDENT;
    public static final Potion BOOST;
    public static final Potion WHIRLWIND;
    public static final Potion PLANAR_BINDING;
    public static final Potion SOUL_SNARE;
    public static final Potion SOUL_FRAY;
    public static final Potion FIRE_FUSE;
    public static final Potion CONSTRICT;
    public static final Potion PLANT_LEECH;
    public static final Potion DEAFNESS;
    public static final Potion BOUNCE;
    public static final Potion CLING;
    public static final Potion SACRIFICIAL_LAMB;
    public static final Potion FLIGHT;
    public static final Potion GROUNDED;
    public static final Potion HEAVY_HEART;
    public static final Potion SUSPENDED;
    public static final Potion FEATHERED;
    public static IForgeRegistry<BloodOrb> BLOOD_ORBS;

    @SubscribeEvent
    public static void registerBloodOrbs(RegistryEvent.Register<BloodOrb> event) {
        ResourceLocation orb = RegistrarBloodMagicItems.BLOOD_ORB.getRegistryName();
        event.getRegistry().registerAll((IForgeRegistryEntry[])new BloodOrb[]{(BloodOrb)new BloodOrb("weak", 1, 5000, 2).withModel(new ModelResourceLocation(orb, "type=weak")).setRegistryName("weak"), (BloodOrb)new BloodOrb("apprentice", 2, 25000, 5).withModel(new ModelResourceLocation(orb, "type=apprentice")).setRegistryName("apprentice"), (BloodOrb)new BloodOrb("magician", 3, 150000, 15).withModel(new ModelResourceLocation(orb, "type=magician")).setRegistryName("magician"), (BloodOrb)new BloodOrb("master", 4, 1000000, 25).withModel(new ModelResourceLocation(orb, "type=master")).setRegistryName("master"), (BloodOrb)new BloodOrb("archmage", 5, 10000000, 50).withModel(new ModelResourceLocation(orb, "type=archmage")).setRegistryName("archmage")});
        if (ConfigHandler.general.enableTierSixEvenThoughThereIsNoContent) {
            event.getRegistry().register(new BloodOrb("transcendent", 6, 30000000, 50).withModel(new ModelResourceLocation(orb, "type=transcendent")).setRegistryName("transcendent"));
        }
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{(Potion)new PotionBloodMagic("Boost", false, 0xFFFFFF, 0, 0).setRegistryName("boost"), (Potion)new PotionBloodMagic("Planar Binding", false, 0, 2, 0).setRegistryName("planar_binding"), (Potion)new PotionBloodMagic("Soul Snare", false, 0xFFFFFF, 3, 0).setRegistryName("soul_snare"), (Potion)new PotionBloodMagic("Soul Fray", true, 0xFFFFFF, 4, 0).setRegistryName("soul_fray"), (Potion)new PotionBloodMagic("Fire Fuse", true, 0xFF3333, 5, 0).setRegistryName("fire_fuse"), (Potion)new PotionBloodMagic("Constriction", true, 0, 6, 0).setRegistryName("constrict"), (Potion)new PotionBloodMagic("Plant Leech", true, 0, 7, 0).setRegistryName("plant_leech"), (Potion)new PotionBloodMagic("Deaf", true, 0, 0, 1).setRegistryName("deafness"), (Potion)new PotionBloodMagic("Bounce", false, 0, 1, 1).setRegistryName("bounce"), (Potion)new PotionBloodMagic("Cling", false, 0, 2, 1).setRegistryName("cling"), (Potion)new PotionBloodMagic("S. Lamb", false, 0, 3, 1).setRegistryName("sacrificial_lamb"), (Potion)new PotionBloodMagic("Flight", false, 0, 4, 0).setRegistryName("flight"), (Potion)new PotionBloodMagic("Grounded", true, 0, 1, 0).setRegistryName("grounded"), (Potion)new PotionBloodMagic("Suspended", false, 0, 1, 0).setRegistryName("suspended"), (Potion)new PotionBloodMagic("Heavy Heart", true, 0, 1, 0).setRegistryName("heavy_heart"), (Potion)new PotionBloodMagic("Feathered", false, 0, 0, 0).setRegistryName("feathered")});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int entities = 0;
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntryBuilder.create().id("blood_light", ++entities).entity(EntityBloodLight.class).name("blood_light").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("soul_snare", ++entities).entity(EntitySoulSnare.class).name("soul_snare").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("soul_arrow", ++entities).entity(EntitySentientArrow.class).name("sentient_arrow").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("meteor", ++entities).entity(EntityMeteor.class).name("meteor").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("sentient_specter", ++entities).entity(EntitySentientSpecter.class).name("sentient_specter").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("mimic", ++entities).entity(EntityMimic.class).name("mimic").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("corrupted_zombie", ++entities).entity(EntityCorruptedZombie.class).name("corrupted_zombie").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("corrupted_sheep", ++entities).entity(EntityCorruptedSheep.class).name("corrupted_sheep").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("corrupted_chicken", ++entities).entity(EntityCorruptedChicken.class).name("corrupted_chicken").tracker(64, 3, true).build(), EntityEntryBuilder.create().id("corrupted_spider", ++entities).entity(EntityCorruptedSpider.class).name("corrupted_spider").tracker(64, 3, true).build()});
    }

    @SubscribeEvent
    public static void onRegistryCreation(RegistryEvent.NewRegistry event) {
        BLOOD_ORBS = new RegistryBuilder().setName(new ResourceLocation("bloodmagic", "blood_orb")).setIDRange(0, Short.MAX_VALUE).setType(BloodOrb.class).addCallback((owner, stage, id, obj, oldObj) -> OrbRegistry.tierMap.put((Object)obj.getTier(), (Object)OrbRegistry.getOrbStack(obj))).create();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (BloodOrb orb : BLOOD_ORBS) {
            ModelResourceLocation modelLocation = orb.getModelLocation();
            if (modelLocation == null) {
                modelLocation = new ModelResourceLocation(orb.getRegistryName(), "inventory");
            }
            ModelLoader.registerItemVariants((Item)RegistrarBloodMagicItems.BLOOD_ORB, (ResourceLocation[])new ResourceLocation[]{modelLocation});
        }
        ModelLoader.setCustomMeshDefinition((Item)RegistrarBloodMagicItems.BLOOD_ORB, stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(ORB_WEAK.getRegistryName(), "inventory");
            }
            BloodOrb orb = (BloodOrb)BLOOD_ORBS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("orb")));
            if (orb == null || orb.getModelLocation() == null) {
                return new ModelResourceLocation(ORB_WEAK.getRegistryName(), "inventory");
            }
            return orb.getModelLocation();
        });
    }

    static {
        ORB_WEAK = ORB_DEF = new BloodOrb("", 0, 0, 0);
        ORB_APPRENTICE = ORB_DEF;
        ORB_MAGICIAN = ORB_DEF;
        ORB_MASTER = ORB_DEF;
        ORB_ARCHMAGE = ORB_DEF;
        ORB_TRANSCENDENT = ORB_DEF;
        BOOST = MobEffects.field_76422_e;
        WHIRLWIND = MobEffects.field_76422_e;
        PLANAR_BINDING = MobEffects.field_76422_e;
        SOUL_SNARE = MobEffects.field_76422_e;
        SOUL_FRAY = MobEffects.field_76422_e;
        FIRE_FUSE = MobEffects.field_76422_e;
        CONSTRICT = MobEffects.field_76422_e;
        PLANT_LEECH = MobEffects.field_76422_e;
        DEAFNESS = MobEffects.field_76422_e;
        BOUNCE = MobEffects.field_76422_e;
        CLING = MobEffects.field_76422_e;
        SACRIFICIAL_LAMB = MobEffects.field_76422_e;
        FLIGHT = MobEffects.field_76422_e;
        GROUNDED = MobEffects.field_76422_e;
        HEAVY_HEART = MobEffects.field_76422_e;
        SUSPENDED = MobEffects.field_76422_e;
        FEATHERED = MobEffects.field_76422_e;
        BLOOD_ORBS = null;
    }
}

