/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.render.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyCircleRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class BindingAlchemyCircleRenderer
extends AlchemyCircleRenderer {
    public static final int numberOfSweeps = 5;
    public static final int startTime = 50;
    public static final int sweepTime = 40;
    public static final int inwardRotationTime = 50;
    public static final float arcLength = (float)Math.sqrt(8.0 - 8.0 * Math.cos(2.5132741228718345));
    public static final float theta2 = 0.31415927f;
    public static final int endTime = 300;
    public final ResourceLocation[] arraysResources = new ResourceLocation[5];
    public float offsetFromFace = -0.9f;

    public BindingAlchemyCircleRenderer() {
        super(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingArray.png"));
        this.arraysResources[0] = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingLightningArray.png");
        this.arraysResources[1] = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingLightningArray.png");
        this.arraysResources[2] = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingLightningArray.png");
        this.arraysResources[3] = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingLightningArray.png");
        this.arraysResources[4] = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/BindingLightningArray.png");
    }

    public float getRotation(int circle, float craftTime) {
        float offset = 2.0f;
        if (circle == -1) {
            return craftTime * 360.0f * 2.0f / 5.0f / 40.0f;
        }
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.5);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getSecondaryRotation(int circle, float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.7);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getVerticalOffset(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            if (craftTime >= 5.0f) {
                if (craftTime <= 40.0f) {
                    return (float)(-0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
                }
                return -0.4f;
            }
            return 0.0f;
        }
        if (craftTime >= 5.0f) {
            if (craftTime <= 40.0f) {
                return (float)(-0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
            }
            return -0.4f;
        }
        return 0.0f;
    }

    public float getInwardRotation(int circle, float craftTime) {
        float offset = 250.0f;
        if (craftTime >= offset) {
            if (craftTime <= offset + 50.0f) {
                return 1.8f * (craftTime - offset);
            }
            return 90.0f;
        }
        return 0.0f;
    }

    @Override
    public void renderAt(TileEntity tile, double x, double y, double z, float craftTime) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float rot = this.getRotation(-1, craftTime);
        float size = 3.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing sideHit = EnumFacing.UP;
        GlStateManager.func_179109_b((float)((float)sideHit.func_82601_c() * this.offsetFromFace), (float)((float)sideHit.func_96559_d() * this.offsetFromFace), (float)((float)sideHit.func_82599_e() * this.offsetFromFace));
        switch (sideHit) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)this.getVerticalOffset(craftTime));
        double var31 = 0.0;
        double var33 = 1.0;
        double var35 = 0.0;
        double var37 = 1.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)(size / 2.0f), (double)(size / 2.0f), 0.0).func_187315_a(var33, var37).func_181675_d();
        wr.func_181662_b((double)(size / 2.0f), (double)(-size / 2.0f), 0.0).func_187315_a(var33, var35).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0).func_187315_a(var31, var35).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), (double)(size / 2.0f), 0.0).func_187315_a(var31, var37).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        for (int i = 0; i < 5; ++i) {
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arraysResources[i]);
            float newSize = 1.0f;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(i, craftTime);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(i, craftTime);
            float rotation = this.getRotation(i, craftTime);
            GlStateManager.func_179137_b((double)((double)distance * Math.sin(angle)), (double)((double)(-distance) * Math.cos(angle)), (double)this.getVerticalOffset(i, craftTime));
            GlStateManager.func_179114_b((float)(i * 360 / 5), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)this.getInwardRotation(i, craftTime), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b((double)(newSize / 2.0f), (double)(newSize / 2.0f), 0.0).func_187315_a(var33, var37).func_181675_d();
            wr.func_181662_b((double)(newSize / 2.0f), (double)(-newSize / 2.0f), 0.0).func_187315_a(var33, var35).func_181675_d();
            wr.func_181662_b((double)(-newSize / 2.0f), (double)(-newSize / 2.0f), 0.0).func_187315_a(var31, var35).func_181675_d();
            wr.func_181662_b((double)(-newSize / 2.0f), (double)(newSize / 2.0f), 0.0).func_187315_a(var31, var37).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public static float getAngleOfCircle(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            float originalAngle = (float)((double)(circle * 2) * Math.PI / 5.0);
            double sweep = (craftTime - 50.0f) / 40.0f;
            if (sweep >= 0.0 && sweep < 5.0) {
                float offset = (int)sweep * 40 + 50;
                originalAngle = (float)((double)originalAngle + (2.5132741228718345 * (double)((int)sweep) + (double)BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep)));
            } else if (sweep >= 5.0) {
                originalAngle = (float)((double)originalAngle + (Math.PI * 4 + (double)((craftTime - 200.0f - 50.0f) * 2.0f) * Math.PI * 2.0 / 5.0 / 40.0));
            }
            return originalAngle;
        }
        return 0.0f;
    }

    public static float getAngle(float craftTime, int sweep) {
        float rDP = craftTime / 40.0f * arcLength;
        float rEnd = (float)Math.sqrt((double)(rDP * rDP + 4.0f) - (double)(2.0f * rDP * 2.0f) * Math.cos(0.3141592741012573));
        return (float)Math.acos((4.0f + rEnd * rEnd - rDP * rDP) / (2.0f * rEnd * 2.0f));
    }

    public static float getDistanceOfCircle(int circle, float craftTime) {
        double sweep = (craftTime - 50.0f) / 40.0f;
        if (sweep >= 0.0 && sweep < 5.0) {
            float offset = (int)sweep * 40 + 50;
            float angle = BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep);
            float thetaPrime = (float)(2.827433379488536 - (double)angle);
            return (float)(2.0 * Math.sin(0.3141592741012573) / Math.sin(thetaPrime));
        }
        if (sweep >= 5.0 && craftTime < 300.0f) {
            return 2.0f - 2.0f * (craftTime - 50.0f - 200.0f) / 50.0f;
        }
        if (craftTime >= 300.0f) {
            return 0.0f;
        }
        return 2.0f;
    }
}

