/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.block.base.BlockEnum;
import WayofTime.bloodmagic.block.enums.EnumRitualController;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.event.RitualEvent;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.imperfect.IImperfectRitualStone;
import WayofTime.bloodmagic.ritual.imperfect.ImperfectRitual;
import WayofTime.bloodmagic.tile.TileImperfectRitualStone;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.helper.RitualHelper;
import amerifrance.guideapi.api.IGuideLinked;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockRitualController
extends BlockEnum<EnumRitualController>
implements IGuideLinked {
    public BlockRitualController() {
        super(Material.field_151576_e, EnumRitualController.class);
        this.func_149663_c("bloodmagic.stone.ritual.");
        this.func_149647_a(BloodMagic.TAB_BM);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177229_b(this.getProperty()) != EnumRitualController.IMPERFECT && tile instanceof TileMasterRitualStone) {
            if (heldItem.func_77973_b() == RegistrarBloodMagicItems.ACTIVATION_CRYSTAL) {
                if (((IBindable)heldItem.func_77973_b()).getBinding(heldItem) == null) {
                    return false;
                }
                String key = RitualHelper.getValidRitual(world, pos);
                if (!key.isEmpty()) {
                    Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
                    if (ritual != null) {
                        EnumFacing direction = RitualHelper.getDirectionOfRitual(world, pos, ritual);
                        if (direction != null && RitualHelper.checkValidRitual(world, pos, ritual, direction)) {
                            if (((TileMasterRitualStone)tile).activateRitual(heldItem, player, BloodMagic.RITUAL_MANAGER.getRitual(key))) {
                                ((TileMasterRitualStone)tile).setDirection(direction);
                                if (state.func_177229_b(this.getProperty()) == EnumRitualController.INVERTED) {
                                    ((TileMasterRitualStone)tile).setInverted(true);
                                }
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.notValid", new Object[0]), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.notValid", new Object[0]), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.ritual.notValid", new Object[0]), true);
                }
            }
        } else if (state.func_177229_b(this.getProperty()) == EnumRitualController.IMPERFECT && tile instanceof TileImperfectRitualStone) {
            IBlockState ritualBlock = world.func_180495_p(pos.func_177984_a());
            ImperfectRitual ritual = BloodMagic.RITUAL_MANAGER.getImperfectRitual(ritualBlock);
            if (ritual == null) {
                return false;
            }
            RitualEvent.ImperfectRitualActivatedEvent event = new RitualEvent.ImperfectRitualActivatedEvent((IImperfectRitualStone)tile, player, ritual);
            return !MinecraftForge.EVENT_BUS.post((Event)event) && ((TileImperfectRitualStone)tile).performRitual(world, pos, ritual, player);
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.func_176201_c(state) == 0 && tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.BREAK_MRS);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.EXPLOSION);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177229_b(this.getProperty()) != EnumRitualController.IMPERFECT ? new TileMasterRitualStone() : new TileImperfectRitualStone();
    }

    @Nullable
    public ResourceLocation getLinkedEntry(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        ImperfectRitual imperfectRitual;
        IBlockState state = world.func_180495_p(pos);
        if (((EnumRitualController)((Object)state.func_177229_b(this.getProperty()))).equals((Object)EnumRitualController.MASTER)) {
            TileMasterRitualStone mrs = (TileMasterRitualStone)world.func_175625_s(pos);
            if (mrs == null || mrs.getCurrentRitual() == null) {
                return null;
            }
            return new ResourceLocation("bloodmagic", "ritual_" + mrs.getCurrentRitual().getName());
        }
        if (((EnumRitualController)((Object)state.func_177229_b(this.getProperty()))).equals((Object)EnumRitualController.IMPERFECT) && (imperfectRitual = BloodMagic.RITUAL_MANAGER.getImperfectRitual(world.func_180495_p(pos.func_177984_a()))) != null) {
            return new ResourceLocation("bloodmagic", "ritual_" + imperfectRitual.getName());
        }
        return null;
    }
}

