/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.inventory.InvIterator;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.util.DankNullUtils;

public class InventoryDankNull
implements IInventory,
Iterable<ItemStack> {
    public static final String INVENTORY_NAME = "danknull-inventory";
    public static final String TAG_SLOT = "Slot";
    public static final String TAG_COUNT = "RealCount";
    private int size = 54;
    private final NonNullList<ItemStack> STACKLIST;
    private final int[] sizesArray;
    private ItemStack dankNullStack = ItemStack.field_190927_a;
    private int numRows = 0;
    private EntityPlayer player;

    public InventoryDankNull(ItemStack dankNull) {
        this.dankNullStack = dankNull;
        this.numRows = this.dankNullStack.func_77952_i() + 1;
        if (DankNullUtils.isCreativeDankNull(dankNull)) {
            --this.numRows;
        }
        this.size = this.numRows * 9;
        this.STACKLIST = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
        this.sizesArray = new int[this.size];
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(dankNull.func_77978_p());
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        if (DankNullUtils.isCreativeDankNull(this.getDankNull()) && index < this.func_70302_i_() && !((ItemStack)this.STACKLIST.get(index)).func_190926_b()) {
            ItemStack tmp = ((ItemStack)this.STACKLIST.get(index)).func_77946_l();
            tmp.func_190920_e(Integer.MAX_VALUE);
            return tmp;
        }
        return index < this.func_70302_i_() ? (ItemStack)this.STACKLIST.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (!this.func_70301_a(index).func_190926_b()) {
            if (DankNullUtils.isCreativeDankNull(this.getDankNull())) {
                ItemStack tmp = this.func_70301_a(index).func_77946_l();
                tmp.func_190920_e(Integer.MAX_VALUE);
                return tmp;
            }
            if (this.func_70301_a(index).func_190916_E() <= amount) {
                ItemStack itemstack = this.func_70301_a(index);
                this.STACKLIST.set(index, (Object)ItemStack.field_190927_a);
                this.setSizeForSlot(index, 0);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.func_70301_a(index).func_77979_a(amount);
            this.setSizeForSlot(index, this.getSizeForSlot(index) - amount);
            if (this.func_70301_a(index).func_190916_E() == 0) {
                this.STACKLIST.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemstack1;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.setInventorySlotContents(index, itemStack, null);
    }

    public void setInventorySlotContents(int index, ItemStack itemStack, TileDankNullDock te) {
        this.STACKLIST.set(index, (Object)itemStack);
        this.func_70296_d();
        if (te != null) {
            te.setInventory(this);
            te.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemDankNull);
    }

    public String func_70005_c_() {
        return INVENTORY_NAME;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            this.STACKLIST.set(index, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return stack;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public void func_174889_b(EntityPlayer player) {
        if (player != null) {
            this.player = player;
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    public NonNullList<ItemStack> getStacks() {
        return this.STACKLIST;
    }

    public int getSizeForSlot(int index) {
        return index >= 0 ? (DankNullUtils.isCreativeDankNull(this.getDankNull()) ? Integer.MAX_VALUE : this.sizesArray[index]) : 0;
    }

    public void setSizeForSlot(int index, int size) {
        if (DankNullUtils.isCreativeDankNull(this.getDankNull())) {
            size = Integer.MAX_VALUE;
        }
        this.sizesArray[index] = size < 0 ? 0 : size;
    }

    public long getMaxStackSize() {
        return DankNullUtils.getDankNullMaxStackSize(this.getDankNull());
    }

    public boolean func_191420_l() {
        for (int x = 0; x < this.size; ++x) {
            if (this.func_70301_a(x).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getDankNull() {
        return !this.dankNullStack.func_190926_b() ? this.dankNullStack : ItemStack.field_190927_a;
    }

    public static boolean isSameItem(@Nonnull ItemStack left, @Nonnull ItemStack right) {
        return !left.func_190926_b() && !right.func_190926_b() && left.func_77969_a(right);
    }

    public void func_70296_d() {
        if (this.getDankNull().func_190926_b()) {
            return;
        }
        if (!this.getDankNull().func_77942_o()) {
            this.getDankNull().func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(this.getDankNull().func_77978_p());
    }

    public void writeToNBT(NBTTagCompound itemTC) {
        NBTTagList nbtTL = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound nbtTC = new NBTTagCompound();
            nbtTC.func_74768_a(TAG_SLOT, i);
            nbtTC.func_74768_a(TAG_COUNT, this.func_70301_a(i).func_190916_E() <= DankNullUtils.getDankNullMaxStackSize(this) ? this.func_70301_a(i).func_190916_E() : DankNullUtils.getDankNullMaxStackSize(this));
            this.func_70301_a(i).func_77955_b(nbtTC);
            nbtTL.func_74742_a((NBTBase)nbtTC);
        }
        itemTC.func_74782_a(this.func_70005_c_(), (NBTBase)nbtTL);
        this.getDankNull().func_77982_d(itemTC);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList nbtTL = compound.func_150297_b(this.func_70005_c_(), 9) ? compound.func_150295_c(this.func_70005_c_(), 10) : new NBTTagList();
        for (int i = 0; i < nbtTL.func_74745_c(); ++i) {
            NBTTagCompound nbtTC = nbtTL.func_150305_b(i);
            if (nbtTC == null) continue;
            int slot = nbtTC.func_74762_e(TAG_SLOT);
            ItemStack stack = new ItemStack(nbtTC);
            if (nbtTC.func_74764_b(TAG_COUNT)) {
                stack.func_190920_e(nbtTC.func_74762_e(TAG_COUNT));
                this.setSizeForSlot(slot, nbtTC.func_74762_e(TAG_COUNT));
            }
            this.STACKLIST.set(slot, (Object)stack);
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

