/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.blocks.tiles;

import javax.annotation.Nullable;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import p455w0rd.danknull.api.IRedstoneControllable;
import p455w0rd.danknull.api.ITOPBlockDisplayOverride;
import p455w0rd.danknull.init.ModBlocks;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.network.VanillaPacketDispatcher;
import p455w0rd.danknull.util.DankNullUtils;

public class TileDankNullDock
extends TileEntity
implements IRedstoneControllable,
ITOPBlockDisplayOverride,
ISidedInventory {
    public static final String TAG_ITEMSTACK = "DankNullStack";
    public static final String TAG_NAME = "PWDock";
    private RedstoneMode redstoneMode = RedstoneMode.REQUIRED;
    private boolean hasRedstoneSignal = false;
    private NonNullList<ItemStack> slots = NonNullList.func_191196_a();
    InventoryDankNull inventory = null;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return !this.getDankNull().func_190926_b() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.getDankNull().func_190926_b() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
        if (state.func_177230_c() == ModBlocks.DANKNULL_DOCK) {
            ItemStack stack = new ItemStack((Block)ModBlocks.DANKNULL_DOCK);
            TileEntity tile = world.func_175625_s(data.getPos());
            if (tile != null && tile instanceof TileDankNullDock) {
                TileDankNullDock te = (TileDankNullDock)tile;
                stack.func_77983_a("BlockEntityTag", (NBTBase)te.func_189515_b(new NBTTagCompound()));
                String dankNull = "/d" + (ModConfig.Options.callItDevNull ? "ev" : "ank") + "/null";
                String msg = DankNullUtils.translate("dn.right_click_with.desc") + (te.getDankNull().func_190926_b() ? " " + dankNull : " " + DankNullUtils.translate("dn.empty_hand_open.desc"));
                ItemStack dockedDankNull = te.getDankNull().func_190926_b() ? ItemStack.field_190927_a : te.getDankNull();
                IProbeInfo topTip = probeInfo.horizontal().item(stack).vertical().itemLabel(stack);
                if (!dockedDankNull.func_190926_b()) {
                    String dockedMsg = ModGlobals.Rarities.getRarityFromMeta((int)dockedDankNull.func_77952_i()).field_77937_e + "" + dockedDankNull.func_82833_r() + "" + TextFormatting.WHITE + " " + DankNullUtils.translate("dn.docked.desc");
                    topTip.text(dockedMsg);
                    ItemStack selectedStack = DankNullUtils.getSelectedStack(this.getInventory());
                    if (!selectedStack.func_190926_b()) {
                        ItemStack tmpStack = selectedStack.func_77946_l();
                        String countText = "";
                        if (selectedStack.func_190916_E() >= 100000) {
                            tmpStack.func_190920_e(1);
                            countText = ", " + DankNullUtils.translate("dn.count.desc") + ": " + (DankNullUtils.isCreativeDankNull(dockedDankNull) ? DankNullUtils.translate("dn.infinite.desc") : "" + selectedStack.func_190916_E());
                        }
                        topTip.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(tmpStack).text(" " + DankNullUtils.translate("dn.selected.desc") + "" + countText);
                        topTip.text(DankNullUtils.translate("dn.extract_mode.desc") + ": " + DankNullUtils.getExtractionModeForStack(dockedDankNull, selectedStack).getTooltip());
                    }
                }
                topTip.text(TextStyleClass.MODNAME.toString() + Tools.getModName((Block)state.func_177230_c()));
                return true;
            }
        }
        return false;
    }

    public InventoryDankNull getInventory() {
        return this.inventory;
    }

    public void setInventory(InventoryDankNull inv) {
        this.inventory = inv;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public int slotCount() {
        return !this.getDankNull().func_190926_b() ? this.getDankNull().func_77952_i() + 9 : 0;
    }

    public ItemStack getSelectedStack() {
        return this.getDankNull().func_190926_b() ? ItemStack.field_190927_a : DankNullUtils.getSelectedStack(this.getInventory());
    }

    public ItemStack getDankNull() {
        return this.getInventory() == null ? ItemStack.field_190927_a : this.getInventory().getDankNull();
    }

    public NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public boolean isRedstoneRequirementMet() {
        switch (this.getRedstoneMode()) {
            default: {
                return true;
            }
            case REQUIRED: {
                return this.hasRSSignal();
            }
            case REQUIRE_NONE: 
        }
        return !this.hasRSSignal();
    }

    @Override
    public boolean hasRSSignal() {
        return this.hasRedstoneSignal;
    }

    @Override
    public void setRSSignal(boolean isPowered) {
        this.hasRedstoneSignal = isPowered;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b(TAG_ITEMSTACK, 10)) {
            this.setInventory(DankNullUtils.getNewDankNullInventory(new ItemStack(compound.func_74775_l(TAG_ITEMSTACK))));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a(TAG_ITEMSTACK, (NBTBase)this.getDankNull().serializeNBT());
        return compound;
    }

    public int func_70302_i_() {
        return !this.getDankNull().func_190926_b() ? this.getInventory().func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int index) {
        ItemStack stack;
        if (this.getInventory() != null && !(stack = this.getInventory().func_70301_a(index)).func_190926_b()) {
            int amountToBeKept = DankNullUtils.getExtractionModeForStack(this.getDankNull(), stack).getNumberToKeep();
            if (stack.func_190916_E() > amountToBeKept) {
                ItemStack availableStack = stack.func_77946_l();
                availableStack.func_190920_e(stack.func_190916_E() - amountToBeKept);
                return availableStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack ret;
        ItemStack itemStack = ret = !this.getDankNull().func_190926_b() ? this.getInventory().func_70298_a(index, count) : ItemStack.field_190927_a;
        if (this.getInventory() != null) {
            DankNullUtils.reArrangeStacks(this.getInventory());
        }
        this.func_70296_d();
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!this.getDankNull().func_190926_b()) {
            this.getInventory().setInventorySlotContents(index, stack, this);
            return;
        }
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(index, stack);
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return !this.getDankNull().func_190926_b() ? Integer.MAX_VALUE : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory() == null ? false : this.getInventory().func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "danknull-inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (!this.getDankNull().func_190926_b() && side == EnumFacing.DOWN) {
            int[] slots = new int[this.func_70302_i_()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return !this.getDankNull().func_190926_b() && DankNullUtils.getExtractionModeForStack(this.getDankNull(), stack) != DankNullUtils.SlotExtractionMode.KEEP_ALL;
    }

    public boolean func_191420_l() {
        return !this.getDankNull().func_190926_b();
    }

    public static enum RedstoneMode {
        REQUIRED,
        REQUIRE_NONE,
        IGNORED;

    }
}

