/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.pipe.PipeRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SchematicBlockPipe
implements ISchematicBlock {
    private NBTTagCompound tileNbt;
    private Rotation tileRotation = Rotation.NONE;

    public static boolean predicate(SchematicBlockContext context) {
        return context.world.func_180495_p(context.pos).func_177230_c() == BCTransportBlocks.pipeHolder;
    }

    @Override
    public void init(SchematicBlockContext context) {
        TileEntity tileEntity = context.world.func_175625_s(context.pos);
        if (tileEntity == null) {
            throw new IllegalStateException();
        }
        this.tileNbt = tileEntity.serializeNBT();
    }

    @Override
    @Nonnull
    public List<ItemStack> computeRequiredItems() {
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            PipeDefinition definition = PipeRegistry.INSTANCE.loadDefinition(this.tileNbt.func_74775_l("pipe").func_74779_i("def"));
            EnumDyeColor color = NBTUtilBC.readEnum(this.tileNbt.func_74775_l("pipe").func_74781_a("col"), EnumDyeColor.class);
            Item item = (Item)PipeApi.pipeRegistry.getItemForPipe(definition);
            if (item != null) {
                builder.add((Object)new ItemStack(item, 1, color == null ? 0 : color.func_176765_a() + 1));
            }
            return builder.build();
        }
        catch (InvalidInputDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SchematicBlockPipe getRotated(Rotation rotation) {
        SchematicBlockPipe schematicBlock = new SchematicBlockPipe();
        schematicBlock.tileNbt = this.tileNbt;
        schematicBlock.tileRotation = this.tileRotation.func_185830_a(rotation);
        return schematicBlock;
    }

    @Override
    public boolean canBuild(World world, BlockPos blockPos) {
        return world.func_175623_d(blockPos);
    }

    @Override
    public boolean build(World world, BlockPos blockPos) {
        TileEntity tileEntity;
        if (world.func_180501_a(blockPos, BCTransportBlocks.pipeHolder.func_176223_P(), 11) && (tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileNbt)) != null) {
            tileEntity.func_145834_a(world);
            world.func_175690_a(blockPos, tileEntity);
            if (this.tileRotation != Rotation.NONE) {
                tileEntity.func_189667_a(this.tileRotation);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean buildWithoutChecks(World world, BlockPos blockPos) {
        TileEntity tileEntity;
        if (world.func_180501_a(blockPos, BCTransportBlocks.pipeHolder.func_176223_P(), 0) && (tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileNbt)) != null) {
            tileEntity.func_145834_a(world);
            world.func_175690_a(blockPos, tileEntity);
            if (this.tileRotation != Rotation.NONE) {
                tileEntity.func_189667_a(this.tileRotation);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuilt(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_177230_c() == BCTransportBlocks.pipeHolder;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("tileNbt", (NBTBase)this.tileNbt);
        nbt.func_74782_a("tileRotation", NBTUtilBC.writeEnum(this.tileRotation));
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        this.tileNbt = nbt.func_74775_l("tileNbt");
        this.tileRotation = NBTUtilBC.readEnum(nbt.func_74781_a("tileRotation"), Rotation.class);
    }
}

