/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gate;

import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import buildcraft.silicon.gate.EnumGateModifier;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class GateVariant {
    public final EnumGateLogic logic;
    public final EnumGateMaterial material;
    public final EnumGateModifier modifier;
    public final int numSlots;
    public final int numTriggerArgs;
    public final int numActionArgs;
    private final int hash;

    public GateVariant(EnumGateLogic logic, EnumGateMaterial material, EnumGateModifier modifier) {
        this.logic = logic;
        this.material = material;
        this.modifier = modifier;
        this.numSlots = material.numSlots / modifier.slotDivisor;
        this.numTriggerArgs = modifier.triggerParams;
        this.numActionArgs = modifier.actionParams;
        this.hash = Objects.hash(new Object[]{logic, material, modifier});
    }

    public GateVariant(NBTTagCompound nbt) {
        this.logic = EnumGateLogic.getByOrdinal(nbt.func_74771_c("logic"));
        this.material = EnumGateMaterial.getByOrdinal(nbt.func_74771_c("material"));
        this.modifier = EnumGateModifier.getByOrdinal(nbt.func_74771_c("modifier"));
        this.numSlots = this.material.numSlots / this.modifier.slotDivisor;
        this.numTriggerArgs = this.modifier.triggerParams;
        this.numActionArgs = this.modifier.actionParams;
        this.hash = Objects.hash(new Object[]{this.logic, this.material, this.modifier});
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("logic", (byte)this.logic.ordinal());
        nbt.func_74774_a("material", (byte)this.material.ordinal());
        nbt.func_74774_a("modifier", (byte)this.modifier.ordinal());
        return nbt;
    }

    public GateVariant(PacketBuffer buffer) {
        this.logic = EnumGateLogic.getByOrdinal(buffer.readUnsignedByte());
        this.material = EnumGateMaterial.getByOrdinal(buffer.readUnsignedByte());
        this.modifier = EnumGateModifier.getByOrdinal(buffer.readUnsignedByte());
        this.numSlots = this.material.numSlots / this.modifier.slotDivisor;
        this.numTriggerArgs = this.modifier.triggerParams;
        this.numActionArgs = this.modifier.actionParams;
        this.hash = Objects.hash(new Object[]{this.logic, this.material, this.modifier});
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.logic.ordinal());
        buffer.writeByte(this.material.ordinal());
        buffer.writeByte(this.modifier.ordinal());
    }

    public String getVariantName() {
        if (this.material.canBeModified) {
            return this.material.tag + "_" + this.logic.tag + "_" + this.modifier.tag;
        }
        return this.material.tag;
    }

    public String getLocalizedName() {
        if (this.material == EnumGateMaterial.CLAY_BRICK) {
            return LocaleUtil.localize("gate.name.basic");
        }
        String gateName = LocaleUtil.localize("gate.name");
        String materialName = LocaleUtil.localize("gate.material." + this.material.tag);
        String logicName = LocaleUtil.localize("gate.logic." + this.logic.tag);
        return String.format(gateName, materialName, logicName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GateVariant other = (GateVariant)obj;
        return other.logic == this.logic && other.material == this.material && other.modifier == this.modifier;
    }

    public int hashCode() {
        return this.hash;
    }
}

