/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.client.model.plug;

import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.silicon.BCSiliconModels;
import buildcraft.silicon.client.model.key.KeyPlugLens;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;

public enum PlugBakerLens implements IPluggableStaticBaker<KeyPlugLens>
{
    INSTANCE;

    private static final Map<KeyPlugLens, List<BakedQuad>> cached;
    private static final IQuadGetter lensCutout;
    private static final IQuadGetter lensTranslucent;
    private static final IQuadGetter filterCutout;
    private static final IQuadGetter filterTranslucent;

    public static void onModelBake() {
        cached.clear();
    }

    private static IQuadGetter getGetter(KeyPlugLens key) {
        switch (key.layer) {
            case CUTOUT: {
                return key.isFilter ? filterCutout : lensCutout;
            }
            case TRANSLUCENT: {
                return key.isFilter ? filterTranslucent : lensTranslucent;
            }
        }
        throw new IllegalArgumentException("Unknown layer " + key.layer);
    }

    @Override
    public List<BakedQuad> bake(KeyPlugLens key) {
        if (!cached.containsKey(key)) {
            MutableQuad[] quads = PlugBakerLens.getGetter(key).get(key.side, key.colour);
            MutableQuad c = new MutableQuad();
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>(quads.length);
            for (MutableQuad q : quads) {
                c.copyFrom(q);
                c.multShade();
                list.add(c.toBakedBlock());
            }
            cached.put(key, list);
        }
        return cached.get(key);
    }

    static {
        cached = new HashMap<KeyPlugLens, List<BakedQuad>>();
        lensCutout = BCSiliconModels::getLensCutoutQuads;
        lensTranslucent = BCSiliconModels::getLensTranslucentQuads;
        filterCutout = BCSiliconModels::getFilterCutoutQuads;
        filterTranslucent = BCSiliconModels::getFilterTranslucentQuads;
    }

    static interface IQuadGetter {
        public MutableQuad[] get(EnumFacing var1, EnumDyeColor var2);
    }
}

