/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingObject;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class ChangingItemStack
extends ChangingObject<ItemStackKey> {
    public ChangingItemStack(NonNullList<ItemStack> stacks) {
        super(ChangingItemStack.makeListArray(stacks));
    }

    public ChangingItemStack(@Nonnull Ingredient ingredient) {
        super(ChangingItemStack.makeRecipeArray(ingredient));
    }

    public ChangingItemStack(ItemStack stack) {
        super(ChangingItemStack.makeStackArray(stack));
    }

    public ChangingItemStack(String oreId) {
        this((NonNullList<ItemStack>)OreDictionary.getOres((String)oreId));
    }

    private static ItemStackKey[] makeListArray(NonNullList<ItemStack> stacks) {
        return ChangingItemStack.makeStackArray((ItemStack[])stacks.toArray((Object[])new ItemStack[0]));
    }

    private static ItemStackKey[] makeStackArray(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new ItemStackKey[]{ItemStackKey.EMPTY};
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            NonNullList subs = NonNullList.func_191196_a();
            stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subs);
            return ChangingItemStack.makeListArray((NonNullList<ItemStack>)subs);
        }
        return new ItemStackKey[]{new ItemStackKey(stack)};
    }

    private static ItemStackKey[] makeRecipeArray(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        return ChangingItemStack.makeStackArray(stacks);
    }

    private static ItemStackKey[] makeStackArray(ItemStack[] stacks) {
        if (stacks.length == 0) {
            return new ItemStackKey[]{ItemStackKey.EMPTY};
        }
        ItemStackKey[] arr = new ItemStackKey[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            arr[i] = new ItemStackKey(stacks[i]);
        }
        return arr;
    }

    public boolean matches(ItemStack target) {
        for (ItemStackKey s : (ItemStackKey[])this.options) {
            if (!StackUtil.isCraftingEquivalent(s.baseStack, target, false)) continue;
            return true;
        }
        return false;
    }
}

