/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.item.ItemDebugger;
import buildcraft.lib.net.MessageDebugResponse;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageDebugRequest
implements IMessage {
    private BlockPos pos;
    private EnumFacing side;
    public static final IMessageHandler<MessageDebugRequest, MessageDebugResponse> HANDLER = (message, ctx) -> {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (!ItemDebugger.isShowDebugInfo((EntityPlayer)player)) {
            return new MessageDebugResponse();
        }
        TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
        if (tile instanceof IDebuggable) {
            ArrayList<String> left = new ArrayList<String>();
            ArrayList<String> right = new ArrayList<String>();
            ((IDebuggable)tile).getDebugInfo(left, right, message.side);
            return new MessageDebugResponse(left, right);
        }
        return null;
    };

    public MessageDebugRequest() {
    }

    public MessageDebugRequest(BlockPos pos, EnumFacing side) {
        this.pos = pos;
        this.side = side;
    }

    public void toBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        buf.func_179255_a(this.pos);
        buf.writeEnumValue((Enum<?>)this.side);
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        this.pos = buf.func_179259_c();
        this.side = buf.func_179257_a(EnumFacing.class);
    }
}

