/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import gnu.trove.list.array.TByteArrayList;

public class DecompactingBitSet {
    public final int bits;
    private final TByteArrayList bytes = new TByteArrayList();
    private int byteIndex = 0;
    private int bitIndex = 0;

    public DecompactingBitSet(int bits, byte[] data) {
        this.bits = bits;
        this.bytes.addAll(data);
    }

    private int nextBit() {
        int offset = this.byteIndex++;
        byte current = this.bytes.get(offset);
        int bit = current >> this.bitIndex & 1;
        ++this.bitIndex;
        if (this.bitIndex == 8) {
            this.bitIndex = 0;
        }
        return bit;
    }

    public int next() {
        int value = 0;
        for (int i = this.bits - 1; i >= 0; --i) {
            int bit = this.nextBit();
            value |= bit << i;
        }
        return value;
    }
}

